/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.config.aspect;

import inc.yukawa.chain.base.core.domain.notification.Template;
import inc.yukawa.chain.base.core.domain.notification.TemplateFilter;
import inc.yukawa.chain.base.hibernate.repo.JpaRepo;
import inc.yukawa.chain.modules.main.core.aspect.NotificationAspect;
import inc.yukawa.chain.modules.main.rest.NotificationAspectRest;
import inc.yukawa.chain.modules.main.service.notification.NotificationService;
import inc.yukawa.chain.modules.main.service.notification.RepoTemplateResolver;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@ComponentScan(basePackageClasses={NotificationService.class})
@Profile(value={"notification-aspect", "all-aspects", "default"})
public class NotificationAspectConfig {
    @Value(value="${chain.main.notification.template.defaultLang:en}")
    private String defaultLang;

    @Bean
    public RepoTemplateResolver thymeleafTemplateResolver(JpaRepo<String, Template, TemplateFilter> templateRepo, @Value(value="${chain.main.notification.template.cacheTTL:15000}") Long cacheTTL) {
        RepoTemplateResolver templateResolver = new RepoTemplateResolver(templateRepo, this.defaultLang);
        templateResolver.setTemplateMode("HTML");
        templateResolver.setCheckExistence(false);
        templateResolver.setCacheable(true);
        templateResolver.setCacheTTLMs(cacheTTL);
        return templateResolver;
    }

    @Bean
    public NotificationAspectRest notificationAspectRest(NotificationAspect aspect) {
        return new NotificationAspectRest(aspect);
    }
}

