/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.config.aspect;

import inc.yukawa.chain.modules.main.core.aspect.GroupAspect;
import inc.yukawa.chain.modules.main.core.aspect.MembershipAspect;
import inc.yukawa.chain.modules.main.core.aspect.UserAspectGeneric;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.modules.main.core.domain.user.UserFilter;
import inc.yukawa.chain.modules.main.rest.GroupsAspectRest;
import inc.yukawa.chain.modules.main.rest.MembershipAspectRest;
import inc.yukawa.chain.modules.main.rest.UserAspectRestBase;
import inc.yukawa.chain.modules.main.service.excel.ExcelConverter;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.constraints.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Configuration
public class UserAspectConfig {
    @Bean(value={"main.excelConverter"})
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public ExcelConverter excelConverter() {
        return new ExcelConverter();
    }

    @Bean
    @Profile(value={"groups-aspect", "all-aspects", "default"})
    public GroupsAspectRest groupsAspectRest(GroupAspect aspect) {
        return new GroupsAspectRest(aspect);
    }

    @Bean
    @Profile(value={"membership-aspect", "all-aspects", "default"})
    public MembershipAspectRest membershipAspectRest(MembershipAspect aspect) {
        return new MembershipAspectRest(aspect);
    }

    @RestController
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public static class UserAspectRest
    extends UserAspectRestBase<User, UserFilter> {
        public UserAspectRest(UserAspectGeneric<User, UserFilter> service) {
            super(service);
        }

        @GetMapping(value={"/{username}"})
        @Operation(summary="loadUser")
        public Mono<User> loadUser(@PathVariable(value="username") @NotNull String username) {
            return this.service.loadUser(new UserFilter(username));
        }
    }
}

