/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.config.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import inc.yukawa.chain.base.webflux.config.WebFluxConfigBase;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PessimisticLockException;
import jakarta.validation.ValidationException;
import java.net.URI;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

@Configuration
@EnableWebFlux
public class WebFluxConfig
extends WebFluxConfigBase
implements WebFluxConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(WebFluxConfig.class);

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
    }

    public RouterFunction<ServerResponse> swaggerRouterFunction() {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)"/swagger-ui/index.html"), req -> ServerResponse.permanentRedirect((URI)URI.create("../webjars/swagger-ui/index.html")).build());
    }

    public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        configurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(this.objectMapper, new MimeType[0]));
        configurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(this.objectMapper, new MimeType[0]));
    }

    @Bean
    @Order(value=-2)
    public ErrorWebExceptionHandler globalErrorHandler(ObjectMapper objectMapper) {
        return (exchange, t) -> {
            HttpStatus status;
            if (t instanceof ValidationException || t instanceof IllegalArgumentException || t instanceof EntityNotFoundException || t instanceof NoResultException || t instanceof PessimisticLockException) {
                LOG.debug("Handling bad request error {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
                status = HttpStatus.BAD_REQUEST;
            } else if (t instanceof EntityExistsException) {
                LOG.warn("Handling bad request error {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
                status = HttpStatus.CONFLICT;
            } else if (t instanceof WebClientResponseException) {
                LOG.warn("Handling external service error {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
                status = ((WebClientResponseException)t).getStatusCode();
            } else if (t instanceof ResponseStatusException) {
                LOG.warn("Handling external service error {} {} from {}", new Object[]{t.getClass(), t.getMessage(), t.getStackTrace()[0]});
                status = ((ResponseStatusException)t).getStatusCode();
            } else {
                LOG.error("Internal server error", t);
                status = HttpStatus.INTERNAL_SERVER_ERROR;
            }
            ServerHttpResponse rsp = exchange.getResponse();
            DataBufferFactory bufferFactory = rsp.bufferFactory();
            Mono dataBuffer = Mono.just((Object)bufferFactory.allocateBuffer()).map(arg_0 -> WebFluxConfig.lambda$globalErrorHandler$1(objectMapper, t, (HttpStatusCode)status, arg_0));
            rsp.setStatusCode((HttpStatusCode)status);
            rsp.getHeaders().setContentType(MediaType.APPLICATION_JSON);
            return rsp.writeWith((Publisher)dataBuffer);
        };
    }

    private static /* synthetic */ DataBuffer lambda$globalErrorHandler$1(ObjectMapper objectMapper, Throwable t, HttpStatusCode status, DataBuffer b) {
        try {
            return b.write(objectMapper.writeValueAsBytes((Object)ResultDetail.error((Object)t.getMessage(), (String)status.toString(), t.getClass())));
        }
        catch (JsonProcessingException e) {
            LOG.error("Error during error handling", (Throwable)e);
            return b.write(e.getMessage().getBytes());
        }
    }
}

