/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.service;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.main.data.repo.AccountRepo;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.AccountEntity;
import inc.yukawa.chain.security.domain.AccountStatus;
import java.time.Instant;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
@Profile(value={"users-aspect", "all-aspects", "default"})
public class AccountService {
    private final AccountRepo repo;
    private final PasswordEncoder encoder;

    public AccountService(AccountRepo repo, PasswordEncoder encoder) {
        this.repo = repo;
        this.encoder = encoder;
    }

    public Mono<AccountEntity> createFor(User u) {
        AccountEntity acc = new AccountEntity();
        acc.setUserId(u.getUserId());
        AccountStatus s = new AccountStatus(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        acc.setStatus(s);
        Account a = u.getAccount();
        if (a != null) {
            acc.setPassword(this.encoder.encode((CharSequence)a.getPassword()));
            acc.setPassChangeDate(Instant.now());
            AccountStatus as = a.getStatus();
            if (as != null) {
                s.setEnabled(as.getEnabled());
                s.setAccountNonExpired(Boolean.valueOf(as.getAccountNonExpired() == null || as.getAccountNonExpired() != false));
                s.setAccountNonLocked(Boolean.valueOf(as.getAccountNonLocked() == null || as.getAccountNonLocked() != false));
                s.setCredentialsNonExpired(Boolean.valueOf(as.getCredentialsNonExpired() == null || as.getCredentialsNonExpired() != false));
            }
        }
        return this.repo.create((Keyed)acc);
    }

    public Mono<Integer> syncPass(String username, String pass) {
        AccountEntity a = new AccountEntity();
        a.setUsername(username);
        a.setPassword(this.encoder.encode((CharSequence)pass));
        return this.repo.setPass(a);
    }

    public Mono<Boolean> passMatches(String userId, String oldPassword) {
        return this.repo.load((Object)userId).map(a -> this.encoder.matches((CharSequence)oldPassword, a.getPassword()));
    }
}

