/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.service;

import inc.yukawa.chain.base.core.anno.ChainRequest;
import inc.yukawa.chain.base.core.anno.ChainService;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.hibernate.repo.JpaRepo;
import inc.yukawa.chain.base.service.InterceptedRepoAspect;
import inc.yukawa.chain.modules.main.core.aspect.GroupAspect;
import inc.yukawa.chain.modules.main.core.domain.group.Group;
import inc.yukawa.chain.modules.main.core.domain.group.GroupFilter;
import inc.yukawa.chain.modules.main.service.user.UserService;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service(value="main.GroupAspect")
@Profile(value={"groups-aspect", "all-aspects", "default"})
@ChainService(value="Groups")
public class GroupService
extends InterceptedRepoAspect<String, Group, GroupFilter>
implements GroupAspect {
    public GroupService(JpaRepo<String, Group, GroupFilter> repo) {
        super(repo);
    }

    @ChainRequest
    public Flux<Group> findGroups(GroupFilter filter) {
        return this.repo.find((Object)filter);
    }

    @ChainRequest
    public Mono<QueryResult<Group>> queryGroups(GroupFilter filter) {
        return this.repo.query((Object)filter);
    }

    @ChainRequest
    public Mono<Group> loadGroup(String key) {
        return this.repo.load((Object)key);
    }

    @ChainRequest
    public Mono<EditResult> editGroup(Group group) {
        return UserService.asEdit((String)"editGroup", (Mono)this.repo.put((Keyed)group), (String)group.key());
    }

    @ChainRequest
    public Mono<EditResult> deleteGroup(String groupId) {
        return UserService.asEdit((String)"deleteGroup", (Mono)this.repo.deleteByKey((Object)groupId), (String)groupId);
    }

    @ChainRequest
    public Mono<EditResult> createGroup(Group group) {
        return UserService.asEdit((String)"createGroup", (Mono)this.repo.put((Keyed)group), (String)group.key());
    }
}

