/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.service;

import inc.yukawa.chain.modules.main.core.domain.user.User;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserIdGenerator {
    @Value(value="${chain.main.user.userId.generator.type:ALPHANUMERIC}")
    private GeneratorType generator;
    @Value(value="${chain.main.user.userId.generator.length:6}")
    private int length;

    public String generate(User user) {
        switch (this.generator) {
            case EXTERNAL: {
                return user.getUserId();
            }
            case USERNAME: {
                return user.getUsername();
            }
            case UUID: {
                return UUID.randomUUID().toString().toLowerCase();
            }
            case NUMERIC: {
                return RandomStringUtils.randomNumeric((int)this.length).toLowerCase();
            }
            case ALPHABETIC: {
                return RandomStringUtils.randomAlphabetic((int)this.length).toLowerCase();
            }
        }
        return RandomStringUtils.randomAlphanumeric((int)this.length).toLowerCase();
    }

    public static enum GeneratorType {
        EXTERNAL,
        USERNAME,
        ALPHANUMERIC,
        ALPHABETIC,
        NUMERIC,
        UUID;

    }
}

