/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.service;

import inc.yukawa.chain.base.core.anno.ChainService;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.notification.Notification;
import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.hibernate.repo.JpaRepo;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.base.mono.repos.CrudRepository;
import inc.yukawa.chain.modules.main.bootdb.service.AccountService;
import inc.yukawa.chain.modules.main.bootdb.service.MembershipService;
import inc.yukawa.chain.modules.main.bootdb.service.UserIdGenerator;
import inc.yukawa.chain.modules.main.core.domain.org.Org;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.modules.main.core.domain.user.UserFilter;
import inc.yukawa.chain.modules.main.core.domain.user.UsernameChange;
import inc.yukawa.chain.modules.main.core.event.user.UserEvent;
import inc.yukawa.chain.modules.main.service.excel.ExcelConverter;
import inc.yukawa.chain.modules.main.service.user.TokenService;
import jakarta.persistence.EntityExistsException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@Service(value="main.UserAspect")
@Profile(value={"users-aspect", "all-aspects", "default"})
@ChainService(value="Users")
public class UserService
extends inc.yukawa.chain.modules.main.service.user.UserService {
    private static final Logger LOG = LoggerFactory.getLogger(UserService.class);
    private final AccountService accountService;
    private final MembershipService membershipService;
    private final UserIdGenerator userIdGenerator;

    public UserService(JpaRepo<String, User, UserFilter> repo, ExcelConverter excelConverter, @Autowired(required=false) KafkaTemplate<String, Notification> notificationTemplate, AccountService accountService, @Autowired(required=false) @Qualifier(value="main.UserEvtWriteDao") MonoWriteDao<String, UserEvent> userEvtDao, MembershipService membershipService, UserIdGenerator userIdGenerator, TokenService tokenService) {
        super(repo, excelConverter, null, notificationTemplate, userEvtDao, tokenService);
        this.accountService = accountService;
        this.membershipService = membershipService;
        this.userIdGenerator = userIdGenerator;
    }

    public Mono<User> create(User entity) {
        entity.setUserId(this.userIdGenerator.generate(entity));
        Mono newUser = this.beforeWrite((Keyed)entity).flatMap(arg_0 -> ((CrudRepository)this.repo).create(arg_0)).flatMap(u -> this.accountService.createFor(entity).thenReturn((Object)entity)).flatMap(u -> this.membershipService.addMembership(u.getUserId(), u.getGroupContexts()).then(Mono.just((Object)entity))).flatMap(u -> this.onWrite((User)u, "CREATE")).flatMap(x$0 -> this.afterWrite((Keyed)x$0));
        return this.loadUser(new UserFilter(entity.getUsername())).flatMap(u -> Mono.error((Throwable)new EntityExistsException("user with given username already exists"))).switchIfEmpty(newUser);
    }

    public Mono<User> update(User entity) {
        entity.setGroupContexts(null);
        return this.withUserId(entity).flatMap(x$0 -> super.update(x$0));
    }

    public Mono<User> merge(User entity) {
        entity.setGroupContexts(null);
        return this.withUserId(entity).flatMap(x$0 -> super.merge(x$0));
    }

    public Mono<User> put(User entity) {
        entity.setGroupContexts(null);
        return this.withUserId(entity).flatMap(x$0 -> super.put(x$0));
    }

    public Mono<User> deleteByKey(String userId) {
        Assert.isTrue((!"admin".equalsIgnoreCase(userId) ? 1 : 0) != 0, (String)"admin user can't be deleted");
        return this.repo.load((Object)userId).switchIfEmpty(this.loadUser(new UserFilter(userId))).flatMap(u -> super.deleteByKey(u.getUserId()));
    }

    protected Mono<User> syncCredentials(User u) {
        return this.accountService.syncPass(u.getUsername(), u.getAccount().getCredentials().getPassword()).thenReturn((Object)u);
    }

    protected Mono<User> syncCredentialsIfOldPassMatches(User user, String oldPassword) {
        return this.withUserId(user).flatMap(u -> this.accountService.passMatches(u.getUserId(), oldPassword)).filter(t -> t).switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("username and password does not match"))).flatMap(t -> this.syncCredentials(user));
    }

    protected Mono<User> doUsernameChange(UsernameChange usernameChange) {
        if ("admin".equalsIgnoreCase(usernameChange.getUsername()) || "admin".equalsIgnoreCase(usernameChange.getNewUsername())) {
            return Mono.error((Throwable)new IllegalArgumentException("admin's username change is not allowed"));
        }
        return this.loadUser(new UserFilter(usernameChange.getNewUsername())).flatMap(u -> Mono.error((Throwable)new EntityExistsException("user with new username already exists"))).switchIfEmpty(this.loadUser(new UserFilter(usernameChange.getUsername()))).switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("username not found"))).flatMap(u -> {
            User user = new User();
            user.setUserId(u.getUserId());
            user.setUsername(usernameChange.getNewUsername());
            return this.beforeWrite((Keyed)user).flatMap(arg_0 -> ((CrudRepository)this.repo).merge(arg_0)).flatMap(x$0 -> this.afterWrite((Keyed)x$0));
        }).flatMap(u -> this.onWrite((User)u, "CHANGE_USERNAME"));
    }

    protected Mono<User> modifyGroups(String username, String orgId, Set<String> groups, String eventName) {
        throw new UnsupportedOperationException("not needed in DB based approach");
    }

    public Mono<User> synchronizeRoles(User user) {
        throw new UnsupportedOperationException("not needed in DB based approach");
    }

    protected Mono<EditResult> doOrgCreate(Org org) {
        LOG.warn("Org creation not supported, skipping...");
        return Mono.just((Object)new EditResult("orgCreate", Org.class, org.key()));
    }

    private Mono<User> withUserId(User entity) {
        if (entity.getUserId() == null && entity.getUsername() != null) {
            return this.loadUser(new UserFilter(entity.getUsername())).map(c -> {
                entity.setUserId(c.getUserId());
                return entity;
            });
        }
        return Mono.just((Object)entity);
    }
}

