/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.config;

import inc.yukawa.chain.modules.main.service.notification.WhatsAppClient;
import io.netty.handler.logging.LogLevel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import org.thymeleaf.TemplateEngine;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.logging.AdvancedByteBufFormat;

@Configuration
@ConditionalOnProperty(prefix="chain.main.whatsapp", name={"enabled"}, havingValue="true")
@Profile(value={"notification-aspect", "all-aspects", "default"})
public class WhatsAppSenderConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WhatsAppSenderConfig.class);
    @Value(value="${chain.main.whatsapp.enabled:false}")
    private boolean enabled;
    @Value(value="${chain.main.whatsapp.apiBaseUrl}")
    public String apiBaseUrl;
    @Value(value="${chain.main.whatsapp.authToken}")
    public String authToken;
    @Value(value="${chain.main.whatsapp.phoneId:}")
    private String phoneId;
    @Value(value="${chain.main.whatsapp.textRequestBodyTemplate:sendWhatsappTextRequestBodyTemplate}")
    private String textRequestBodyTemplate;
    @Value(value="${chain.main.whatsapp.templatedRequestBodyTemplate:sendWhatsappTemplatedRequestBodyTemplate}")
    private String templatedRequestBodyTemplate;

    @Bean
    public WhatsAppClient whatsAppClient(TemplateEngine templateEngine) {
        if (!this.enabled) {
            LOG.info("WhatsApp integration is disabled");
            return null;
        }
        LOG.info("WhatsApp integration is enabled");
        WhatsAppClient client = new WhatsAppClient(this.whatsAppWebClient(), templateEngine, this.phoneId);
        client.setTextRequestBodyTemplate(this.textRequestBodyTemplate);
        client.setTemplatedRequestBodyTemplate(this.templatedRequestBodyTemplate);
        return client;
    }

    private WebClient whatsAppWebClient() {
        HttpClient httpClient = (HttpClient)HttpClient.create().wiretap("reactor.netty.http.client.HttpClient", LogLevel.DEBUG, AdvancedByteBufFormat.TEXTUAL);
        return WebClient.builder().baseUrl(this.apiBaseUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).defaultHeaders(header -> header.setBearerAuth(this.authToken)).defaultHeaders(header -> header.setContentType(MediaType.APPLICATION_JSON)).defaultHeaders(header -> header.setAccept(List.of(MediaType.APPLICATION_JSON))).build();
    }
}

