/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.config.web;

import inc.yukawa.chain.security.jwt.config.WebFluxSecurityBase;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
@Profile(value={"jwt", "!open"})
public class WebFluxSecurityAtomic
extends WebFluxSecurityBase {
    private static final Logger log = LoggerFactory.getLogger(WebFluxSecurityAtomic.class);

    @Bean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
        return this.configureAuthenticated(http).build();
    }

    @Bean(value={"main.PermitEndpoints"})
    public List<String> permitAllEndpoints() {
        ArrayList<String> permitAllEndpoints = new ArrayList<String>(super.permitAllEndpoints());
        permitAllEndpoints.add("/users/register");
        permitAllEndpoints.add("/users/password/self-reset");
        permitAllEndpoints.add("/users/username/self-change");
        permitAllEndpoints.add("/orgs/icon/*");
        return permitAllEndpoints;
    }
}

