/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.bootdb.service;

import inc.yukawa.chain.base.core.anno.ChainRequest;
import inc.yukawa.chain.base.core.anno.ChainService;
import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.hibernate.repo.JpaRepo;
import inc.yukawa.chain.base.mono.repos.CrudRepository;
import inc.yukawa.chain.base.service.InterceptedRepoAspect;
import inc.yukawa.chain.modules.main.core.aspect.MembershipAspect;
import inc.yukawa.chain.modules.main.core.domain.group.Member;
import inc.yukawa.chain.modules.main.core.domain.group.MemberFilter;
import inc.yukawa.chain.modules.main.core.domain.group.MemberPK;
import inc.yukawa.chain.modules.main.core.domain.group.Membership;
import inc.yukawa.chain.modules.main.core.domain.group.UserGroups;
import inc.yukawa.chain.modules.main.service.user.UserService;
import inc.yukawa.chain.security.domain.GroupContext;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service(value="main.MembershipAspect")
@Profile(value={"membership-aspect", "all-aspects", "default"})
@ChainService(value="Membership")
public class MembershipService
extends InterceptedRepoAspect<MemberPK, Member, MemberFilter>
implements MembershipAspect {
    public MembershipService(JpaRepo<MemberPK, Member, MemberFilter> repo) {
        super(repo);
    }

    @ChainRequest
    public Mono<EditResult> assign(Membership membership) {
        Assert.notNull((Object)membership.getGroupName(), (String)"groupName");
        Mono res = Flux.fromIterable((Iterable)(membership.getUserIds() != null ? membership.getUserIds() : Collections.emptySet())).map(u -> new Member(u, membership.getGroupName(), membership.getOrgId())).concatMap(arg_0 -> ((MembershipService)this).put(arg_0)).collectList();
        return UserService.asEdit((String)"assign", (Mono)res, (String)Objects.toString(membership.getUserIds()));
    }

    @ChainRequest
    public Mono<EditResult> remove(Membership membership) {
        Assert.notNull((Object)membership.getGroupName(), (String)"groupName");
        Assert.notNull((Object)membership.getOrgId(), (String)"orgId");
        Mono res = Flux.fromIterable((Iterable)(membership.getUserIds() != null ? membership.getUserIds() : Collections.emptySet())).map(u -> new Member(u, membership.getGroupName(), membership.getOrgId())).concatMap(arg_0 -> ((MembershipService)this).delete(arg_0)).collectList();
        return UserService.asEdit((String)"remove", (Mono)res, (String)Objects.toString(membership.getUserIds()));
    }

    @ChainRequest
    public Mono<EditResult> replace(Membership membership) {
        Assert.notNull((Object)membership.getGroupName(), (String)"groupName");
        Assert.notNull((Object)membership.getOrgId(), (String)"orgId");
        Assert.notNull((Object)membership.getUserIds(), (String)"userIds");
        MemberFilter f = new MemberFilter();
        f.setGroupName(membership.getGroupName());
        f.setOrgId(membership.getOrgId());
        return this.repo.find((Object)f).filter(m -> !membership.getUserIds().contains(m.getUserId())).concatMap(arg_0 -> ((MembershipService)this).delete(arg_0)).then(this.assign(membership));
    }

    @ChainRequest
    public Mono<EditResult> assignUserGroups(@NotNull @Valid UserGroups userGroups) {
        this.validate(userGroups);
        Mono res = Flux.fromIterable((Iterable)(userGroups.getGroupNames() != null ? userGroups.getGroupNames() : Collections.emptySet())).map(group -> new Member(userGroups.getUserId(), group, userGroups.getOrgId())).concatMap(arg_0 -> ((MembershipService)this).put(arg_0)).collectList();
        return UserService.asEdit((String)"assignUserGroups", (Mono)res, (String)Objects.toString(userGroups.getGroupNames()));
    }

    @ChainRequest
    public Mono<EditResult> removeUserGroups(@NotNull @Valid UserGroups userGroups) {
        this.validate(userGroups);
        Mono res = Flux.fromIterable((Iterable)(userGroups.getGroupNames() != null ? userGroups.getGroupNames() : Collections.emptySet())).map(group -> new Member(userGroups.getUserId(), group, userGroups.getOrgId())).concatMap(arg_0 -> ((MembershipService)this).delete(arg_0)).collectList();
        return UserService.asEdit((String)"removeUserGroups", (Mono)res, (String)Objects.toString(userGroups.getGroupNames()));
    }

    @ChainRequest
    public Mono<EditResult> replaceUserGroups(@NotNull @Valid UserGroups userGroups) {
        this.validate(userGroups);
        MemberFilter f = new MemberFilter();
        f.setUserId(userGroups.getUserId());
        f.setOrgId(userGroups.getOrgId());
        return this.repo.find((Object)f).filter(m -> !userGroups.getGroupNames().contains(m.getGroupName())).concatMap(arg_0 -> ((MembershipService)this).delete(arg_0)).then(this.assignUserGroups(userGroups));
    }

    private void validate(UserGroups userGroups) {
        Assert.notNull((Object)userGroups.getGroupNames(), (String)"groupNames");
        Assert.notNull((Object)userGroups.getOrgId(), (String)"orgId");
        Assert.notNull((Object)userGroups.getUserId(), (String)"userId");
    }

    Flux<Member> addMembership(String userId, Set<GroupContext> contexts) {
        if (contexts == null || contexts.isEmpty()) {
            return Flux.empty();
        }
        return Flux.fromIterable(contexts).filter(c -> c.getGroups() != null && c.getOrgId() != null).flatMapIterable(c -> c.getGroups().stream().map(name -> new Member(userId, name, c.getOrgId())).collect(Collectors.toList())).concatMap(arg_0 -> ((CrudRepository)this.repo).put(arg_0));
    }
}

