/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.elastic.dao.ElasticIndexAdmin;
import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.base.mono.repos.MonoRepository;
import inc.yukawa.chain.kafka.dao.mono.KafkaAsyncWriteDao;
import inc.yukawa.chain.modules.main.core.domain.setting.Setting;
import inc.yukawa.chain.modules.main.core.domain.setting.SettingFilter;
import inc.yukawa.chain.modules.main.service.setting.SettingElasticReadDao;
import inc.yukawa.chain.modules.main.service.setting.SettingIndexAdmin;
import inc.yukawa.chain.modules.main.service.setting.SettingRepository;
import inc.yukawa.chain.modules.main.service.setting.SettingsService;
import jakarta.validation.Validator;
import org.apache.kafka.clients.admin.NewTopic;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ResourceLoader;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

@Configuration
@Profile(value={"settings-aspect", "all-aspects", "default"})
public class SettingsAspectConfig {
    @Bean(value={"main.SettingsIndexAdmin"})
    @Profile(value={"admin-aspect", "all-aspects", "default"})
    public ElasticIndexAdmin settingsIndexAdmin(RestHighLevelClient client, @Value(value="${chain.main.settings.index}") String index, ResourceLoader resourceLoader) {
        return new ElasticIndexAdmin(index, client){};
    }

    @Bean(value={"main.SettingWriteDao"})
    @Primary
    public MonoWriteDao<String, Setting> settingWriteDao(@Qualifier(value="main.SettingDataTopic") NewTopic topic, ReactiveKafkaProducerTemplate<String, Object> template) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Bean(value={"main.SettingReadDao", "main.SettingLoadDao"})
    public MonoReadDao<String, Setting, SettingFilter> settingReadDao(@Value(value="${chain.main.settings.index}") String indexName, RestHighLevelClient client, ObjectMapper mapper) {
        return new SettingElasticReadDao(indexName, client, mapper);
    }

    @Bean(value={"main.SettingIndexAdmin"})
    public SettingIndexAdmin settingIndexAdmin(@Value(value="${chain.main.settings.index}") String indexName, RestHighLevelClient client, ObjectMapper mapper) {
        return new SettingIndexAdmin(indexName, client);
    }

    @Bean(value={"main.SettingRepository"})
    public SettingRepository settingRepository(@Qualifier(value="main.SettingLoadDao") MonoLoadDao<String, Setting> loadDao, @Qualifier(value="main.SettingReadDao") MonoReadDao<String, Setting, SettingFilter> readDao, @Qualifier(value="main.SettingWriteDao") MonoWriteDao<String, Setting> writeDao) {
        return new SettingRepository(loadDao, readDao, writeDao);
    }

    @Bean(value={"main.SettingAspect"})
    public SettingsService settingAspect(SettingRepository repository, SettingIndexAdmin indexAdmin, Validator validator) {
        return new SettingsService((MonoRepository)repository, indexAdmin, validator);
    }
}

