/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.init;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.kafka.config.InitConfigBase;
import inc.yukawa.chain.modules.main.core.domain.group.Group;
import java.util.List;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

@Configuration
public class InitGroupsConfig
extends InitConfigBase<Group> {
    public static final String NAME = "groups";
    @Value(value="${chain.main.user.default.orgId:#{null}}")
    protected String defaultOrgId;

    @Autowired
    public InitGroupsConfig(@Value(value="classpath:/META-INF/init/init-groups-config.json") Resource res, ObjectMapper mapper, ReactiveKafkaProducerTemplate<String, Object> template, @Qualifier(value="main.GroupDataTopic") NewTopic topic) {
        super(NAME, res, mapper, template, topic.name());
    }

    protected void enhance(Group record) {
        if ("%DEFAULT_ORG%".equals(record.getOrgId())) {
            record.setOrgId(this.defaultOrgId);
        }
        if (record.getName() == null && record.getInfo() != null) {
            if (record.getOrgId() != null) {
                record.setName(record.getOrgId() + "-" + record.getInfo().getShortName());
            } else {
                record.setName(record.getInfo().getShortName());
            }
        }
    }

    @Bean(value={"init-runner-groups"})
    @Profile(value={"init", "init-groups"})
    protected ApplicationRunner runner() {
        return args -> this.doInit();
    }

    protected TypeReference<List<Group>> typeRef() {
        return new TypeReference<List<Group>>(){};
    }
}

