/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.init;

import com.fasterxml.jackson.core.type.TypeReference;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.person.Address;
import inc.yukawa.chain.base.core.domain.person.Person;
import inc.yukawa.chain.kafka.config.InitConfigBase;
import inc.yukawa.chain.modules.main.core.domain.group.Group;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.modules.main.service.group.GroupsRepo;
import inc.yukawa.chain.modules.main.service.user.UserRepo;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.AccountStatus;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.domain.GroupContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import reactor.core.scheduler.Schedulers;

@Configuration
public class InitUserConfig
extends InitConfigBase<User> {
    public static final String NAME = "users";
    public static final String GROUP_ADMINS = "ADMINS";
    public static final String GROUP_USER_MANAGERS = "USER_MANAGERS";
    public static final String GROUP_SYS_ADMINS = "SYS_ADMINS";
    @Autowired(required=false)
    private UserRepo userRepo;
    @Autowired(required=false)
    private GroupsRepo groupsRepo;
    @Value(value="${chain.main.user.default.orgId:#{null}}")
    protected String defaultOrgId;
    @Value(value="${chain.main.user.init.admin.username}")
    protected String adminUser;
    @Value(value="${chain.main.user.init.admin.password}")
    protected String adminPass;

    public InitUserConfig() {
        super(NAME, null, null, null, null);
    }

    public void doInit() {
        if (this.groupsRepo != null) {
            this.sampleGroups().stream().map(g -> this.groupsRepo.put(g)).forEach(u -> u.subscribeOn(Schedulers.boundedElastic()).delaySubscription(Duration.ofSeconds(10L)).subscribe());
        }
        if (this.userRepo != null) {
            this.sampleUsers().stream().map(u -> this.userRepo.put((Keyed)u)).forEach(u -> u.subscribeOn(Schedulers.boundedElastic()).delaySubscription(Duration.ofSeconds(20L)).subscribe());
        }
    }

    @Bean(value={"init-runner-users"})
    @Profile(value={"init", "init-users"})
    protected ApplicationRunner runner() {
        return args -> this.doInit();
    }

    protected TypeReference<List<User>> typeRef() {
        return new TypeReference<List<User>>(){};
    }

    private List<User> sampleUsers() {
        ArrayList<User> users = new ArrayList<User>();
        if (!"false".equals(this.adminUser)) {
            users.add(this.user(this.adminUser, this.adminPass, GROUP_ADMINS));
        }
        return users;
    }

    private List<Group> sampleGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(this.newSysGroup(GROUP_ADMINS, "Super Users", null, "ROLE_ADMIN"));
        return groups;
    }

    protected Group newSysGroup(String gid, String name, String desc, String ... roles) {
        Group group = new Group();
        group.setName(gid);
        group.setInfo(new Info(name, null, desc));
        group.setType("sys");
        if (!"false".equals(this.adminUser)) {
            group.setCreated(new Change(this.adminUser, new Date()));
            group.setChange(group.getCreated());
        }
        if (roles != null) {
            group.setRoles(Arrays.asList(roles));
        }
        return group;
    }

    private User user(String name, String pass, String ... groups) {
        Person person = new Person();
        person.setFirstName(name);
        person.setLastName(name);
        person.setEmail(name + "@example.com");
        person.setCompanyName("Yukawa");
        person.setAddresses(new ArrayList());
        person.getAddresses().add(new Address("Somestreet", "1", "Somecity", "00000"));
        Account account = new Account(new Credentials(name, pass), null, new AccountStatus(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), new HashMap());
        User user = new User(name, person);
        user.setAccount(account);
        user.setGroups(new HashSet<String>(Arrays.asList(groups)));
        user.setGroupContexts(new HashSet());
        user.getGroupContexts().add(new GroupContext(this.defaultOrgId, new HashSet<String>(Arrays.asList(groups))));
        user.setCreated(new Change(name, new Date()));
        user.setChange(user.getCreated());
        user.setOrgIds(new LinkedList());
        if (this.defaultOrgId != null) {
            user.setDefaultOrgId(this.defaultOrgId);
            user.getOrgIds().add(this.defaultOrgId);
        }
        return user;
    }
}

