/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.kafka;

import inc.yukawa.chain.kafka.connect.admin.ConnectAdmin;
import inc.yukawa.chain.kafka.connect.admin.ConnectClient;
import inc.yukawa.chain.kafka.connect.admin.ConnectClientWebFlux;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class ConnectConfig {
    @Value(value="${app.prefix}")
    protected String appPrefix;
    @Value(value="${chain.admin.connect.rest.url}")
    protected String connectUrl;
    @Value(value="${chain.admin.connect.elastic.url}")
    protected String elasticUrl;

    @Bean(value={"main.KafkaConnectClient"})
    @Profile(value={"admin-aspect", "all-aspects", "default"})
    public ConnectClient kafkaConnectClient() {
        return new ConnectClientWebFlux(WebClient.builder().baseUrl(this.connectUrl).build());
    }

    @Bean(value={"main.KafkaConnectAdmin"})
    @Profile(value={"admin-aspect", "all-aspects", "default"})
    public ConnectAdmin kafkaConnectAdmin(@Qualifier(value="main.KafkaConnectClient") ConnectClient client) {
        String name = this.appPrefix + "elastic-data";
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("connector.class", "io.confluent.connect.elasticsearch.ElasticsearchSinkConnector");
        config.put("type.name", "_doc");
        config.put("errors.log.include.messages", "true");
        config.put("behavior.on.null.values", "delete");
        config.put("topics", "");
        config.put("name", name);
        config.put("connection.url", this.elasticUrl);
        config.put("value.converter", "org.apache.kafka.connect.json.JsonConverter");
        config.put("value.converter.schemas.enable", "false");
        config.put("key.converter.schemas.enable", "false");
        config.put("key.ignore", "false");
        config.put("errors.log.enable", "false");
        config.put("topics.regex", this.appPrefix + ".*-data");
        config.put("connection.timeout.ms", "5000");
        config.put("read.timeout.ms", "10000");
        config.put("tasks.max", "2");
        config.put("max.retries", "100000");
        config.put("schema.ignore", "true");
        config.put("behavior.on.malformed.documents", "warn");
        config.put("batch.size", "100");
        config.put("max.buffered.records", "500");
        HashMap<CallSite, HashMap<String, Object>> connectors = new HashMap<CallSite, HashMap<String, Object>>();
        connectors.put((CallSite)((Object)name), config);
        return new ConnectAdmin(client, connectors);
    }
}

