/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.kafka;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import inc.yukawa.chain.kafka.config.KafkaStreamsConfigBase;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.listener.RetryListener;
import org.springframework.kafka.support.ExponentialBackOffWithMaxRetries;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.util.backoff.BackOff;

@Configuration
public class KafkaConfig
extends KafkaStreamsConfigBase {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConfig.class);
    @Value(value="${chain.main.kafka.consumer.retry.attempts:20}")
    private Integer retryAttempts;

    public ObjectMapper objectMapper() {
        ObjectMapper mapper = super.objectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    @Bean
    public ReactiveKafkaProducerTemplate<String, Object> reactiveKafkaProducerTemplate(KafkaProperties properties, ObjectMapper mapper) {
        return this.reactiveKafkaTemplate(properties, Serdes.String().serializer(), (Serializer)new JsonSerializer(mapper));
    }

    @Bean(name={"main.ListenerContainerFactory"})
    public ConcurrentKafkaListenerContainerFactory<String, Object> listenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.newJsonConsumerFactory());
        ExponentialBackOffWithMaxRetries backOff = new ExponentialBackOffWithMaxRetries(this.retryAttempts.intValue());
        DefaultErrorHandler errorHandler = new DefaultErrorHandler((BackOff)backOff);
        errorHandler.setRetryListeners(new RetryListener[]{(record, ex, deliveryAttempt) -> LOG.warn("Retry attempt {} after: {}", (Object)deliveryAttempt, (Object)(ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()))});
        errorHandler.addRetryableExceptions(new Class[]{SocketTimeoutException.class});
        errorHandler.addNotRetryableExceptions(new Class[]{NullPointerException.class});
        factory.setCommonErrorHandler((CommonErrorHandler)errorHandler);
        factory.getContainerProperties().setAckMode(ContainerProperties.AckMode.RECORD);
        return factory;
    }

    @Bean
    public Map<String, Object> consumerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", JsonDeserializer.class);
        props.put("enable.auto.commit", false);
        props.put("auto.offset.reset", "earliest");
        return props;
    }

    private ConsumerFactory<String, Object> newJsonConsumerFactory() {
        JsonDeserializer objectJsonDeserializer = new JsonDeserializer(this.objectMapper());
        objectJsonDeserializer.addTrustedPackages(new String[]{"*"});
        return this.newConsumerFactory((Deserializer)new ErrorHandlingDeserializer((Deserializer)new StringDeserializer()), (Deserializer)new ErrorHandlingDeserializer((Deserializer)objectJsonDeserializer));
    }

    private <K, V> ConsumerFactory<K, V> newConsumerFactory(Deserializer<K> keyParser, Deserializer<V> valueParser) {
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(this.consumerConfigs());
        if (keyParser != null) {
            consumerFactory.setKeyDeserializer(keyParser);
        }
        if (valueParser != null) {
            consumerFactory.setValueDeserializer(valueParser);
        }
        return consumerFactory;
    }

    @Bean(value={"main.UserStreamsProps"})
    public Properties userStreamsProps() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.baseStreamsProps());
        props.put("application.id", this.appId + "User");
        return props;
    }

    @Bean(value={"main.GroupStreamsProps"})
    public Properties groupStreamsProps() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.baseStreamsProps());
        props.put("application.id", this.appId + "Group");
        return props;
    }

    @Bean(value={"main.RoleStreamsProps"})
    public Properties roleStreamsProps() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.baseStreamsProps());
        props.put("application.id", this.appId + "Role");
        return props;
    }

    @Bean(value={"main.OrgStreamsProps"})
    public Properties orgStreamsProps() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.baseStreamsProps());
        props.put("application.id", this.appId + "Org");
        return props;
    }

    @Bean(value={"main.LabelStreamProps"})
    @Profile(value={"labels-aspect", "all-aspects", "default"})
    public Properties labelStreamProps() {
        Properties props = this.baseStreamsProps();
        props.put("topology.optimization", "all");
        props.put("application.id", this.appId + "-label");
        return props;
    }

    @Bean(value={"main.TemplateStreamProps"})
    @Profile(value={"template-aspect", "all-aspects", "default"})
    public Properties templateStreamProps() {
        Properties props = this.baseStreamsProps();
        props.put("topology.optimization", "all");
        props.put("application.id", this.appId + "-template");
        return props;
    }
}

