/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.migration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.modules.main.core.aspect.UserAspectGeneric;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.modules.main.core.domain.user.UserFilter;
import inc.yukawa.chain.security.domain.GroupContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

@Configuration
@Profile(value={"migrate", "mig270"})
public class MigrateUserConfig_2_7_0 {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateUserConfig_2_7_0.class);
    @Autowired(required=false)
    @Qualifier(value="main.UserAspect")
    public UserAspectGeneric<User, UserFilter> userService;
    @Value(value="${chain.main.user.default.orgId:#{null}}")
    protected String defaultOrgId;

    @Bean(value={"main.MigrateUserConfig_2_7_0.runner"})
    public ApplicationRunner migrate() {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"migration", (Object)"blank", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER_ADMIN"}));
        return arg_0 -> this.lambda$migrate$1((Authentication)authentication, arg_0);
    }

    private Mono<EditResult> doMigrate() {
        LOG.warn("Triggering user migration");
        EditResult r = new EditResult("migrate", User.class);
        return this.userService.findUsers(new UserFilter()).filter(this::inScope).map(this::migrateUser).flatMap(arg_0 -> this.userService.editUser(arg_0)).map(arg_0 -> ((EditResult)r).merge(arg_0)).collectList().thenReturn((Object)r);
    }

    private boolean inScope(User user) {
        boolean migrated;
        boolean bl = migrated = user.getDefaultOrgId() != null && user.getOrgIds() != null && !user.getOrgIds().isEmpty() && user.getGroupContexts() != null;
        if (migrated) {
            LOG.debug("Already migrated: {}", (Object)user.getUsername());
        }
        return !migrated;
    }

    private User migrateUser(User user) {
        if (user.getOrgIds() == null) {
            user.setOrgIds((List)Lists.newArrayList((Object[])new String[]{this.defaultOrgId}));
        }
        if (user.getDefaultOrgId() == null && !user.getOrgIds().isEmpty()) {
            user.setDefaultOrgId((String)user.getOrgIds().get(0));
        }
        if (user.getGroupContexts() == null && user.getDefaultOrgId() != null) {
            Set groups = user.getGroups() != null ? user.getGroups() : new HashSet();
            user.setGroupContexts((Set)Sets.newHashSet((Object[])new GroupContext[]{new GroupContext(user.getDefaultOrgId(), groups)}));
        }
        if (user.getGroups() != null) {
            user.setGroups(null);
        }
        if (user.getAccount() != null) {
            user.getAccount().setCredentials(null);
        }
        LOG.info("Migrating: {}@{} with groups: {}", new Object[]{user.getUsername(), user.getDefaultOrgId(), user.getGroupContexts()});
        return user;
    }

    private /* synthetic */ void lambda$migrate$1(Authentication authentication, ApplicationArguments args) throws Exception {
        if (this.userService != null) {
            this.doMigrate().switchIfEmpty(Mono.error((Throwable)new IllegalStateException("Migration failed"))).doOnNext(r -> LOG.info("Migration result: {}", r)).contextWrite((ContextView)ReactiveSecurityContextHolder.withAuthentication((Authentication)authentication)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        }
    }
}

