/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.security;

import inc.yukawa.chain.modules.main.service.user.TokenService;
import inc.yukawa.chain.security.jwt.config.JwtConfigBase;
import inc.yukawa.chain.security.jwt.config.JwtSettings;
import inc.yukawa.chain.security.jwt.token.json.JsonWebTokenFactory;
import inc.yukawa.chain.security.jwt.util.AuthContextHelper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JwtConfig
extends JwtConfigBase {
    @Bean
    public AuthContextHelper authContextHelper(@Value(value="${chain.security.account.details.groupsKey:groups}") String groupsKey, @Value(value="${chain.security.account.details.organisationIdsKey:organisationIds}") String organisationIdsKey) {
        return new AuthContextHelper(groupsKey, organisationIdsKey);
    }

    @Bean
    @ConfigurationProperties(prefix="chain.security.jwt")
    public JwtSettings jwtSettings() {
        return super.jwtSettings();
    }

    @Bean
    public TokenService tokenService(JwtSettings settings) {
        return new TokenService(new JsonWebTokenFactory(settings, null));
    }
}

