/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.notification.Notification;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.base.mono.repos.CrudRepository;
import inc.yukawa.chain.kafka.connect.admin.ConnectAdmin;
import inc.yukawa.chain.kafka.dao.mono.KafkaAsyncWriteDao;
import inc.yukawa.chain.kafka.event.EventBasedRepo;
import inc.yukawa.chain.modules.main.core.aspect.OrgsAspectGeneric;
import inc.yukawa.chain.modules.main.core.aspect.UserAspectGeneric;
import inc.yukawa.chain.modules.main.core.domain.org.Org;
import inc.yukawa.chain.modules.main.core.domain.org.OrgFilter;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.modules.main.core.domain.user.UserFilter;
import inc.yukawa.chain.modules.main.core.event.user.UserEvent;
import inc.yukawa.chain.modules.main.rest.OrgAspectRestBase;
import inc.yukawa.chain.modules.main.rest.UserAspectRestBase;
import inc.yukawa.chain.modules.main.service.excel.ExcelConverter;
import inc.yukawa.chain.modules.main.service.org.OrgElasticReadDao;
import inc.yukawa.chain.modules.main.service.org.OrgRepoBase;
import inc.yukawa.chain.modules.main.service.org.OrgService;
import inc.yukawa.chain.modules.main.service.user.TokenService;
import inc.yukawa.chain.modules.main.service.user.UserElasticReadDao;
import inc.yukawa.chain.modules.main.service.user.UserRepo;
import inc.yukawa.chain.modules.main.service.user.UserService;
import inc.yukawa.chain.security.jwt.util.AuthContextHelper;
import org.apache.kafka.clients.admin.NewTopic;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.config.EnableWebFlux;

@SpringBootApplication(scanBasePackages={"inc.yukawa.chain.modules.main.config", "inc.yukawa.chain.modules.main.rest", "inc.yukawa.chain.modules.main.service", "inc.yukawa.chain.modules.main.kafka", "inc.yukawa.chain.modules.main.config.kafka", "inc.yukawa.chain.modules.main.config.aspect", "inc.yukawa.chain.modules.main.service.user"})
@EnableWebFlux
@PropertySource(value={"classpath:release.properties"}, ignoreResourceNotFound=true)
public class MainModuleApp {
    public static void main(String[] args) {
        SpringApplication.run(MainModuleApp.class, (String[])args);
    }

    @Bean(value={"main.excelConverter"})
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public ExcelConverter excelConverter() {
        return new ExcelConverter();
    }

    @Bean(value={"main.UserEventDao"})
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public MonoWriteDao<String, UserEvent> userWriteDao(@Qualifier(value="main.UserEventTopic") NewTopic topic, ReactiveKafkaProducerTemplate<String, Object> template) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Bean(value={"main.UserReadDao"})
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public MonoReadDao<String, User, UserFilter> userReadDao(RestHighLevelClient restClient, @Value(value="${chain.main.user.index}") String topic, ObjectMapper mapper) {
        return new UserElasticReadDao(restClient, topic, mapper);
    }

    @Bean(value={"main.UserRepo"})
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public UserRepo userRepo(@Qualifier(value="main.UserReadDao") MonoReadDao<String, User, UserFilter> readDao, @Qualifier(value="main.UserEventDao") MonoWriteDao<String, UserEvent> eventDao, AuthContextHelper authContextHelper) {
        return new UserRepo(readDao, eventDao, authContextHelper);
    }

    @Bean(value={"main.UserAspect"})
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public UserService userService(UserRepo userRepo, ExcelConverter converter, OrgRepoBase<Org, OrgFilter> orgRepo, KafkaTemplate<String, Notification> emailNotificationSender, @Autowired(required=false) @Qualifier(value="main.UserEvtWriteDao") MonoWriteDao<String, UserEvent> userEvtDao, TokenService tokenService) {
        return new UserService((CrudRepository)userRepo, converter, orgRepo, emailNotificationSender, userEvtDao, tokenService);
    }

    @Bean(value={"main.OrgWriteDao"})
    @Profile(value={"orgs-aspect", "all-aspects", "default"})
    public MonoWriteDao<String, Org> orgWriteDao(@Qualifier(value="main.OrgDataTopic") NewTopic topic, ReactiveKafkaProducerTemplate<String, Object> template) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Bean(value={"main.OrgReadDao"})
    @Profile(value={"orgs-aspect", "all-aspects", "default"})
    public MonoReadDao<String, Org, OrgFilter> orgReadDao(RestHighLevelClient restClient, @Value(value="${chain.main.org.index}") String index, ObjectMapper mapper) {
        return new OrgElasticReadDao(index, restClient, mapper, Org.class);
    }

    @Bean(value={"main.OrgRepo"})
    @Profile(value={"orgs-aspect", "all-aspects", "default"})
    public OrgRepoBase<Org, OrgFilter> orgRepo(@Qualifier(value="main.OrgReadDao") MonoReadDao<String, Org, OrgFilter> readDao, @Qualifier(value="main.OrgWriteDao") MonoWriteDao<String, Org> writeDao) {
        return new OrgRepoBase<Org, OrgFilter>(readDao, writeDao){};
    }

    @Bean(value={"main.OrgAspect"})
    @Profile(value={"orgs-aspect", "all-aspects", "default"})
    public OrgsAspectGeneric<Org, OrgFilter> orgService(OrgRepoBase<Org, OrgFilter> orgRepo, UserRepo userRepo) {
        return new OrgService(orgRepo, (EventBasedRepo)userRepo);
    }

    @RestController
    @Profile(value={"admin-aspect", "all-aspects", "default"})
    public static class ConnectAdminRest
    extends inc.yukawa.chain.kafka.connect.admin.ConnectAdminRest {
        @Autowired
        public ConnectAdminRest(@Qualifier(value="main.KafkaConnectAdmin") ConnectAdmin connectAdmin) {
            super(connectAdmin);
        }
    }

    @RestController
    @Profile(value={"orgs-aspect", "all-aspects", "default"})
    public static class OrgAspectRest
    extends OrgAspectRestBase<Org, OrgFilter> {
        public OrgAspectRest(OrgsAspectGeneric<Org, OrgFilter> aspect) {
            super(aspect);
        }
    }

    @RestController
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public static class UserAspectRest
    extends UserAspectRestBase<User, UserFilter> {
        public UserAspectRest(UserAspectGeneric<User, UserFilter> aspect) {
            super(aspect);
        }
    }
}

