/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.label.Label;
import inc.yukawa.chain.base.core.domain.label.LabelFilter;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.kafka.dao.mono.KafkaAsyncWriteDao;
import inc.yukawa.chain.modules.main.core.aspect.LabelAspect;
import inc.yukawa.chain.modules.main.service.label.LabelEvent;
import inc.yukawa.chain.modules.main.service.label.LabelRepo;
import inc.yukawa.chain.modules.main.service.label.LabelService;
import inc.yukawa.chain.modules.main.service.label.elastic.LabelReadDao;
import inc.yukawa.chain.modules.main.service.label.stream.LabelEventHandler;
import inc.yukawa.chain.modules.main.service.label.stream.LabelEventStream;
import java.util.Properties;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.kafka.clients.admin.NewTopic;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

@Configuration
@Profile(value={"labels-aspect", "all-aspects", "default"})
public class LabelsAspectConfig {
    @Bean(value={"main.LabelEventWriteDao"})
    public MonoWriteDao<String, LabelEvent> labelEventWriteDao(@Qualifier(value="main.LabelEventTopic") NewTopic topic, ReactiveKafkaProducerTemplate<String, Object> template) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Bean(value={"main.LabelReadDao", "main.LabelLoadDao"})
    public MonoReadDao<String, Label, LabelFilter> labelReadDao(@Value(value="${chain.main.label.index}") String indexName, RestHighLevelClient client, ObjectMapper mapper) {
        return new LabelReadDao(client, mapper, indexName);
    }

    @Bean(value={"main.LabelRepo"})
    public LabelRepo labelRepository(@Qualifier(value="main.LabelReadDao") MonoReadDao<String, Label, LabelFilter> readDao, MonoWriteDao<String, LabelEvent> writeDao) {
        return new LabelRepo(readDao, writeDao);
    }

    @Bean(value={"main.LabelsAspect"})
    public LabelAspect labelAspect(LabelRepo repository) {
        return new LabelService(repository, l -> l.setId(RandomStringUtils.randomAlphanumeric((int)6).toLowerCase()));
    }

    @Bean
    public LabelEventHandler labelEventHandler() {
        return new LabelEventHandler();
    }

    @Bean(value={"main.LabelStream"})
    public LabelEventStream eventStream(@Qualifier(value="main.LabelStreamProps") Properties streamProps, @Qualifier(value="main.LabelDataTopic") NewTopic dataTopic, @Qualifier(value="main.LabelEventTopic") NewTopic eventTopic, @Qualifier(value="main.LabelAssignmentEventTopic") NewTopic labelAssignmentEventTopic, ObjectMapper mapper, LabelEventHandler handler) {
        return new LabelEventStream(streamProps, dataTopic, eventTopic, labelAssignmentEventTopic, mapper, handler);
    }
}

