/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.notification.Template;
import inc.yukawa.chain.base.core.domain.notification.TemplateFilter;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.base.mono.repos.CrudRepository;
import inc.yukawa.chain.kafka.dao.mono.KafkaAsyncWriteDao;
import inc.yukawa.chain.modules.main.core.aspect.TemplateAspect;
import inc.yukawa.chain.modules.main.service.template.TemplateEvent;
import inc.yukawa.chain.modules.main.service.template.TemplateReadDao;
import inc.yukawa.chain.modules.main.service.template.TemplateRepo;
import inc.yukawa.chain.modules.main.service.template.TemplateService;
import inc.yukawa.chain.modules.main.service.template.stream.TemplateEventHandler;
import inc.yukawa.chain.modules.main.service.template.stream.TemplateEventStream;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

@Configuration
@Profile(value={"template-aspect", "all-aspects", "default"})
public class TemplateAspectConfig {
    @Bean(value={"main.TemplateEventWriteDao"})
    public MonoWriteDao<String, TemplateEvent> templateEventWriteDao(@Qualifier(value="main.TemplateEventTopic") NewTopic topic, ReactiveKafkaProducerTemplate<String, Object> template) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Bean(value={"main.TemplateReadDao", "main.TemplateLoadDao"})
    public MonoReadDao<String, Template, TemplateFilter> templateReadDao(@Value(value="${chain.main.template.index}") String indexName, RestHighLevelClient client, ObjectMapper mapper) {
        return new TemplateReadDao(client, mapper, indexName);
    }

    @Bean(value={"main.TemplateRepo"})
    public TemplateRepo templateRepository(@Qualifier(value="main.TemplateReadDao") MonoReadDao<String, Template, TemplateFilter> readDao, MonoWriteDao<String, TemplateEvent> writeDao) {
        return new TemplateRepo(readDao, writeDao);
    }

    @Bean(value={"main.TemplatesAspect"})
    public TemplateAspect templateAspect(TemplateRepo repository) {
        return new TemplateService((CrudRepository)repository);
    }

    @Bean
    public TemplateEventHandler templateEventHandler() {
        return new TemplateEventHandler();
    }

    @Bean(value={"main.TemplateStream"})
    public TemplateEventStream templateEventStream(@Qualifier(value="main.TemplateStreamProps") Properties streamProps, @Qualifier(value="main.TemplateDataTopic") NewTopic dataTopic, @Qualifier(value="main.TemplateEventTopic") NewTopic eventTopic, ObjectMapper mapper, TemplateEventHandler handler) {
        return new TemplateEventStream(streamProps, dataTopic, eventTopic, mapper, handler);
    }
}

