/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.kafka.dao.mono.KafkaAsyncWriteDao;
import inc.yukawa.chain.modules.main.core.domain.group.Group;
import inc.yukawa.chain.modules.main.core.domain.group.GroupFilter;
import inc.yukawa.chain.modules.main.core.event.user.UserEvent;
import inc.yukawa.chain.modules.main.kafka.store.GroupStore;
import inc.yukawa.chain.modules.main.service.group.GroupElasticReadDao;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

@Configuration
public class UserAspectConfig {
    @Bean(value={"main.GroupLoadDao"})
    @Profile(value={"groups-aspect", "all-aspects", "default"})
    public MonoReadDao<String, Group, GroupFilter> groupLoadDao(@Qualifier(value="main.GroupStreamsProps") Properties props, ObjectMapper mapper) {
        return new GroupStore(mapper, props);
    }

    @Bean(value={"main.GroupReadDao"})
    @Profile(value={"groups-aspect", "all-aspects", "default"})
    public MonoReadDao<String, Group, GroupFilter> groupReadDao(@Value(value="${chain.main.group.index}") String indexName, RestHighLevelClient restClient, ObjectMapper mapper) {
        return new GroupElasticReadDao(indexName, restClient, mapper);
    }

    @Bean(value={"main.GroupWriteDao"})
    @Profile(value={"groups-aspect", "all-aspects", "default"})
    public MonoWriteDao<String, Group> groupWriteDao(@Qualifier(value="main.GroupDataTopic") NewTopic topic, ReactiveKafkaProducerTemplate<String, Object> template) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Bean(value={"main.UserEventWriteDao"})
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public MonoWriteDao<String, UserEvent> userEventWriteDao(@Qualifier(value="main.UserEventTopic") NewTopic topic, ReactiveKafkaProducerTemplate<String, Object> template) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Bean(value={"main.UserEvtWriteDao"})
    @Profile(value={"users-aspect", "all-aspects", "default"})
    public MonoWriteDao<String, UserEvent> userEvtWriteDao(@Qualifier(value="main.UserEvtTopic") NewTopic topic, ReactiveKafkaProducerTemplate<String, Object> template) {
        return new KafkaAsyncWriteDao(template, topic);
    }
}

