/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.init;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import inc.yukawa.chain.kafka.connect.admin.ConnectAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Configuration
public class InitConnectorConfig {
    private static final Logger LOG = LoggerFactory.getLogger(InitConnectorConfig.class);
    private final ConnectAdmin connectAdmin;

    public InitConnectorConfig(ConnectAdmin connectAdmin) {
        this.connectAdmin = connectAdmin;
    }

    @Bean(value={"init-runner-connect"})
    @Profile(value={"!no-init-connect"})
    protected ApplicationRunner runner() {
        return args -> this.doInit();
    }

    private void doInit() {
        this.connectAdmin.findConnectorNames().filter(c -> c.contains("elastic-data")).collectList().flatMap(existingConnectors -> {
            if (!existingConnectors.isEmpty()) {
                LOG.info("Elastic data connectors already initialized: {}", existingConnectors);
                return Mono.just((Object)new EditResult("initConnectors", String.class, "", ResultDetail.ok((String)("already initialized: " + existingConnectors))));
            }
            LOG.info("Creating elastic data connectors");
            return this.connectAdmin.createConnectors().doOnNext(res -> LOG.debug("Connector create result: {}", res));
        }).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }
}

