/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.init;

import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.person.Address;
import inc.yukawa.chain.base.core.domain.person.Person;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.modules.main.service.user.UserRepo;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.AccountStatus;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.domain.GroupContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import reactor.core.scheduler.Schedulers;

@Configuration
@Profile(value={"sample", "sample-user"})
public class SampleConfig {
    @Autowired(required=false)
    private UserRepo userRepo;
    @Value(value="${chain.main.user.default.orgId:#{null}}")
    protected String defaultOrgId;

    @Bean(value={"main.demoUsers"})
    public List<User> demoUsers() {
        ArrayList<User> users = new ArrayList<User>();
        users.add(this.user("user1", "user", this.defaultOrgId, "USERS"));
        users.add(this.user("user2", "user", this.defaultOrgId, "USERS"));
        return users;
    }

    @Bean(value={"main.demoCreator"})
    public ApplicationRunner sampleCreator(@Qualifier(value="main.demoUsers") List<User> demoUsers) {
        return args -> demoUsers.stream().map(u -> this.userRepo.put((Keyed)u)).forEach(u -> u.subscribeOn(Schedulers.boundedElastic()).subscribe());
    }

    private User user(String name, String pass, String orgId, String ... groups) {
        Person person = new Person();
        person.setFirstName(name);
        person.setLastName(name);
        person.setEmail(name + "@yukawa.de");
        person.setCompanyName(orgId);
        person.setAddresses(new ArrayList());
        person.getAddresses().add(new Address("Sesame Street", "1", "Cologne", "00000"));
        Account account = new Account(new Credentials(name, pass), null, new AccountStatus(Boolean.valueOf(true)), new HashMap());
        User user = new User(name, person);
        user.setAccount(account);
        user.setOrgIds(Collections.singletonList(orgId));
        user.setGroupContexts(new HashSet());
        user.getGroupContexts().add(new GroupContext(orgId, new HashSet<String>(Arrays.asList(groups))));
        user.setCreated(new Change(name, new Date()));
        user.setChange(user.getCreated());
        return user;
    }
}

