/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.config.init;

import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.person.Address;
import inc.yukawa.chain.modules.main.core.domain.org.Org;
import inc.yukawa.chain.modules.main.core.domain.org.OrgFilter;
import inc.yukawa.chain.modules.main.service.org.OrgRepoBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import reactor.core.scheduler.Schedulers;

@Configuration
@Profile(value={"sample", "sample-org"})
public class SampleOrgConfig {
    @Autowired(required=false)
    private OrgRepoBase<Org, OrgFilter> orgRepo;

    @Bean(value={"main.demoOrgs"})
    public List<Org> demoOrgs() {
        ArrayList<Org> orgs = new ArrayList<Org>();
        orgs.add(this.yukawaOrg());
        return orgs;
    }

    @Bean(value={"main.demoOrgsCreator"})
    public ApplicationRunner sampleCreator(@Qualifier(value="main.demoOrgs") List<Org> demoOrgs) {
        return args -> {
            if (this.orgRepo != null) {
                demoOrgs.stream().map(arg_0 -> this.orgRepo.edit(arg_0)).forEach(u -> u.subscribeOn(Schedulers.boundedElastic()).subscribe());
            }
        };
    }

    private Org yukawaOrg() {
        Org org = new Org();
        org.setOrgId("yuk");
        org.setCompanyName("Yukawa Systems GmbH");
        org.setEmail("yukawa@example.com");
        org.setInfo(new Info("Yukawa GmbH", "Yukawa", "Some longer company description"));
        org.setAddresses(new ArrayList());
        org.getAddresses().add(new Address("Somestreet", "1", "Somecity", "00000"));
        org.setPhoneNumber("+49000000000");
        org.setTaxId("DE111222333");
        org.setWebsite("www.yukawa.de");
        org.setCreated(new Change("sample", new Date()));
        org.setChange(org.getCreated());
        return org;
    }
}

