/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.main.client;

import inc.yukawa.chain.base.core.domain.notification.Notification;
import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.modules.main.core.domain.group.UserGroups;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.modules.main.core.domain.user.UsernameChange;
import inc.yukawa.chain.security.domain.Credentials;
import java.time.Duration;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class ChainMainClient {
    protected final WebClient delegator;

    public ChainMainClient(WebClient delegator) {
        this.delegator = delegator;
    }

    public Mono<EditResult> notificationSend(Notification notification) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/notification/send", new Object[0])).body((Publisher)Mono.just((Object)notification), Notification.class).retrieve().bodyToMono(EditResult.class);
    }

    public Mono<EditResult> createUser(User entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/users", new Object[0])).body((Publisher)Mono.just((Object)entity), User.class).retrieve().bodyToMono(EditResult.class).timeout(Duration.ofSeconds(60L));
    }

    public Mono<EditResult> mergeUser(User entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/users/merge", new Object[0])).body((Publisher)Mono.just((Object)entity), User.class).retrieve().bodyToMono(EditResult.class);
    }

    public Mono<User> loadUser(String username) {
        return this.delegator.get().uri("/users/" + username, new Object[0]).retrieve().bodyToMono(User.class).timeout(Duration.ofSeconds(20L));
    }

    public Mono<EditResult> deleteUser(String username) {
        return this.delegator.delete().uri("/users/" + username, new Object[0]).retrieve().bodyToMono(EditResult.class).timeout(Duration.ofSeconds(60L));
    }

    public Mono<EditResult> changePassword(Credentials entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/users/password/change", new Object[0])).body((Publisher)Mono.just((Object)entity), Credentials.class).retrieve().bodyToMono(EditResult.class).timeout(Duration.ofSeconds(20L));
    }

    public Mono<EditResult> changeUsername(UsernameChange entity) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/users/username/change", new Object[0])).body((Publisher)Mono.just((Object)entity), UsernameChange.class).retrieve().bodyToMono(EditResult.class).timeout(Duration.ofSeconds(20L));
    }

    public Mono<EditResult> assignToGroup(UserGroups userGroups) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/membership/user/assign", new Object[0])).body((Publisher)Mono.just((Object)userGroups), UserGroups.class).retrieve().bodyToMono(EditResult.class);
    }

    public Mono<EditResult> removeFromGroup(UserGroups userGroups) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/membership/user/remove", new Object[0])).body((Publisher)Mono.just((Object)userGroups), UserGroups.class).retrieve().bodyToMono(EditResult.class);
    }

    public Mono<EditResult> replaceUserGroups(UserGroups userGroups) {
        return ((WebClient.RequestBodySpec)this.delegator.post().uri("/membership/user/replace", new Object[0])).body((Publisher)Mono.just((Object)userGroups), UserGroups.class).retrieve().bodyToMono(EditResult.class);
    }
}

