/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.core.domain.group;

import com.fasterxml.jackson.annotation.JsonIgnore;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.entity.ChainEntityBase;
import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.organization.Organized;
import inc.yukawa.chain.modules.main.core.MainEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlType(name="Group")
@XmlRootElement(name="group")
@Schema
public class Group
extends ChainEntityBase
implements Created,
Organized,
Keyed<String> {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_SYSTEM = "sys";
    @Schema(description="Group name", requiredMode=Schema.RequiredMode.REQUIRED, example="users")
    private String name;
    @Schema(description="Parent Id", example="all")
    private String parentId;
    @Schema(description="Group Type", example="sys")
    private String type;
    @Schema(description="Roles", requiredMode=Schema.RequiredMode.REQUIRED)
    private List<String> roles = new ArrayList<String>();
    @Schema(example="YUK")
    private String orgId;
    @Schema(description="Created")
    private Change created;

    public Group() {
    }

    public Group(String name) {
        this.name = name;
    }

    public Group(String name, List<String> roles) {
        this.name = name;
        this.roles = roles;
    }

    @JsonIgnore
    @XmlTransient
    public ChainKey getKey() {
        return new ChainKey("main", (Object)MainEntity.Group, this.getName());
    }

    public String key() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public Change getChange() {
        return this.change;
    }

    public void setChange(Change change) {
        this.change = change;
    }

    public Change getCreated() {
        return this.created;
    }

    public void setCreated(Change created) {
        this.created = created;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.name != null) {
            sb.append(", name='").append(this.name).append('\'');
        }
        if (this.parentId != null) {
            sb.append(", parentId=").append(this.parentId);
        }
        if (this.roles != null) {
            sb.append(", roles=").append(this.roles);
        }
        if (this.info != null) {
            sb.append(", info=").append(this.info);
        }
        if (this.orgId != null) {
            sb.append(", orgId=").append(this.orgId);
        }
        if (this.change != null) {
            sb.append(", change=").append(this.change);
        }
        if (this.created != null) {
            sb.append(", created=").append(this.created);
        }
        return sb;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }
}

