/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.core.domain.group;

import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.organization.Organized;
import inc.yukawa.chain.modules.main.core.domain.group.MemberPK;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Objects;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlType(name="Membership")
@XmlRootElement(name="membership")
@Schema
public class Member
implements Serializable,
Organized,
Keyed<MemberPK>,
Changed {
    private static final long serialVersionUID = 2L;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="aaaa1111")
    private String userId;
    @Schema(description="Group name", requiredMode=Schema.RequiredMode.REQUIRED, example="users")
    private String groupName;
    @Schema(description="Group name", requiredMode=Schema.RequiredMode.REQUIRED, example="users")
    private String orgId;
    private Change change;

    public Member() {
    }

    public Member(String userId, String groupName, String orgId) {
        this.userId = userId;
        this.groupName = groupName;
        this.orgId = orgId;
    }

    public MemberPK key() {
        return new MemberPK(this.userId, this.groupName, this.orgId);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Change getChange() {
        return this.change;
    }

    public void setChange(Change change) {
        this.change = change;
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.userId != null) {
            sb.append(", userId=").append(this.userId);
        }
        if (this.orgId != null) {
            sb.append(", orgId=").append(this.orgId);
        }
        if (this.groupName != null) {
            sb.append(", groupName=").append(this.groupName);
        }
        if (this.change != null) {
            sb.append(", change=").append(this.change);
        }
        return sb;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Keyed k = (Keyed)o;
        return this.key() != null && Objects.equals(this.key(), k.key());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

