/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.core.domain.org;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.entity.ChainEntity;
import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.organization.Organized;
import inc.yukawa.chain.base.core.domain.person.Address;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="org")
@XmlType(name="Org")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class Org
implements Serializable,
Changed,
Created,
ChainEntity,
Organized {
    private static final long serialVersionUID = 2L;
    @Schema(description="Organization ID", example="yuk")
    private String orgId;
    @Schema(description="TAX identifier", example="DE113344")
    private String taxId;
    @Schema(description="Organization name", example="Yukawa Systems GmbH")
    private String companyName;
    @Schema(description="Address")
    private List<Address> addresses;
    private Info info;
    @Schema(description="place for storing logos, etc. Base64 encoded")
    private String icon;
    @Schema(description="Email", example="yukawa@example.com")
    private String email;
    @Schema(description="Phone number", example="+49 100 200 300")
    private String phoneNumber;
    @Schema(description="Web Page", example="http://yukawa.de/")
    private String website;
    @Schema(description="Changed")
    private Change change;
    @Schema(description="Created")
    private Change created;

    @JsonIgnore
    public ChainKey getKey() {
        return new ChainKey("main", Org.class, this.orgId);
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @XmlElementWrapper(name="addresses")
    @XmlElement(name="address")
    @JsonProperty(value="addresses")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public Change getChange() {
        return this.change;
    }

    public void setChange(Change change) {
        this.change = change;
    }

    public Change getCreated() {
        return this.created;
    }

    public void setCreated(Change created) {
        this.created = created;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.orgId != null) {
            sb.append(", orgId='").append(this.orgId).append('\'');
        }
        if (this.taxId != null) {
            sb.append(", taxId='").append(this.taxId).append('\'');
        }
        if (this.companyName != null) {
            sb.append(", companyName='").append(this.companyName).append('\'');
        }
        if (this.addresses != null) {
            sb.append(", addresses='").append(this.addresses).append('\'');
        }
        if (this.info != null) {
            sb.append(", info='").append(this.info).append('\'');
        }
        if (this.email != null) {
            sb.append(", email='").append(this.email).append('\'');
        }
        if (this.phoneNumber != null) {
            sb.append(", phoneNumber='").append(this.phoneNumber).append('\'');
        }
        if (this.website != null) {
            sb.append(", website='").append(this.website).append('\'');
        }
        if (this.change != null) {
            sb.append(", change='").append(this.change).append('\'');
        }
        if (this.created != null) {
            sb.append(", created='").append(this.created).append('\'');
        }
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Org)) {
            return false;
        }
        Org org = (Org)o;
        return Objects.equals(this.orgId, org.orgId) && Objects.equals(this.taxId, org.taxId) && Objects.equals(this.companyName, org.companyName) && Objects.equals(this.addresses, org.addresses) && Objects.equals(this.info, org.info) && Objects.equals(this.email, org.email) && Objects.equals(this.phoneNumber, org.phoneNumber) && Objects.equals(this.website, org.website) && Objects.equals(this.change, org.change) && Objects.equals(this.created, org.created);
    }

    public int hashCode() {
        return Objects.hash(this.orgId, this.taxId, this.companyName, this.addresses, this.info, this.email, this.phoneNumber, this.website, this.change, this.created);
    }
}

