/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.core.domain.push;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.modules.main.core.domain.push.OperatingSystem;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import lombok.Generated;

@Schema(description="Represents the push token for push notifications")
@XmlType(name="PushToken")
@XmlRootElement(name="push-token")
public class PushToken
implements Serializable,
Keyed<String> {
    @Schema(example="abcd", description="Generated by FCM", requiredMode=Schema.RequiredMode.REQUIRED)
    private String token;
    @Schema(example="00001", description="User (push token owner)", requiredMode=Schema.RequiredMode.REQUIRED)
    private String userId;
    @Schema(description="Last push token validity check")
    private Instant lastTokenCheck;
    @Schema(description="Related mobile operating system", requiredMode=Schema.RequiredMode.REQUIRED, allowableValues={"IOS", "ANDROID"})
    private OperatingSystem operatingSystem;

    public String key() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        PushToken pushToken = (PushToken)o;
        return this.token != null && Objects.equals(this.token, pushToken.token);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public Instant getLastTokenCheck() {
        return this.lastTokenCheck;
    }

    @Generated
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setLastTokenCheck(Instant lastTokenCheck) {
        this.lastTokenCheck = lastTokenCheck;
    }

    @Generated
    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    @Generated
    public String toString() {
        return "PushToken(token=" + this.getToken() + ", userId=" + this.getUserId() + ", lastTokenCheck=" + this.getLastTokenCheck() + ", operatingSystem=" + this.getOperatingSystem() + ")";
    }

    @Generated
    public PushToken() {
    }
}

