/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.core.domain.setting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.entity.ChainEntity;
import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.organization.Organized;
import inc.yukawa.chain.modules.main.core.MainEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;

@XmlRootElement(name="setting")
@XmlType(name="Setting")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class Setting
implements Serializable,
Changed,
ChainEntity,
Organized,
Keyed<String> {
    private static final long serialVersionUID = 20190923L;
    private String name;
    private String shortName;
    private String desc;
    @NotEmpty
    @Schema(description="module / service setting belongs to", requiredMode=Schema.RequiredMode.REQUIRED, example="main")
    private String module;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="1337")
    private String value;
    @Schema(example="yuk")
    private String orgId;
    @Valid
    @Schema
    private Change change;

    public Setting() {
    }

    public Setting(String module, String value, String name, String shortName, String desc) {
        this.name = name;
        this.shortName = shortName;
        this.desc = desc;
        this.module = module;
        this.value = value;
    }

    public Setting(String orgId, String module, String value, String name, String shortName, String desc) {
        this.orgId = orgId;
        this.name = name;
        this.shortName = shortName;
        this.desc = desc;
        this.module = module;
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("module=").append(this.module);
        sb.append(", shortName=").append(this.shortName);
        sb.append(", name=").append(this.name);
        sb.append(", value=").append(this.value);
        sb.append(", orgId=").append(this.orgId);
        if (this.desc != null) {
            sb.append(", desc='").append(this.desc).append('\'');
        }
        if (this.getChange() != null) {
            sb.append(", change=").append(this.getChange());
        }
        sb.append('}');
        return sb.toString();
    }

    public String key() {
        return this.getId();
    }

    @XmlTransient
    @JsonIgnore
    public String getId() {
        return Setting.formatId(this.orgId, this.module, this.getShortName());
    }

    public static String formatId(String orgId, String module, String shortName) {
        return orgId + "-" + module + "-" + shortName;
    }

    @JsonIgnore
    public void setId(String id) {
    }

    @JsonIgnore
    @XmlTransient
    public ChainKey getKey() {
        return new ChainKey("main", (Object)MainEntity.Setting, this.getId());
    }

    @NotEmpty
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="storage.location.central")
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Schema(example="Central Storage Location")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="description", example="default central storage location")
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public Change getChange() {
        return this.change;
    }

    public void setChange(Change change) {
        this.change = change;
    }
}

