/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.core.domain.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import inc.yukawa.chain.base.core.domain.access.Owner;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.entity.ChainEntityOwned;
import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.person.Person;
import inc.yukawa.chain.modules.main.core.MainEntity;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.GroupContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@XmlType(name="User")
@XmlRootElement(name="user")
@Schema
public class User
extends ChainEntityOwned
implements Serializable,
Changed,
Created,
Keyed<String> {
    private static final long serialVersionUID = 2L;
    @Schema(example="aaaa1111")
    private String userId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="admin")
    private String username;
    @Schema(description="Account data", requiredMode=Schema.RequiredMode.REQUIRED)
    private Account account;
    @Schema(description="Personal data")
    private Person person;
    @Schema(description="Created")
    private Change created;
    @Schema(description="User details")
    private Map<String, Object> details;
    @Deprecated
    @Schema(description="User groups")
    private Set<String> groups;
    @Schema(description="User groups context")
    private Set<GroupContext> groupContexts;
    @Schema
    @Deprecated
    private List<String> orgIds;
    @Schema(description="Default organisation")
    private String defaultOrgId;
    private Owner owner;

    public User() {
    }

    public User(String username) {
        this(username, null);
    }

    public User(String username, Person person) {
        this.username = username;
        this.person = person;
    }

    public String key() {
        return this.userId != null ? this.userId : this.username;
    }

    @JsonIgnore
    @XmlTransient
    public ChainKey getKey() {
        return new ChainKey("main", (Object)MainEntity.User, this.username);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Change getCreated() {
        return this.created;
    }

    @XmlElementWrapper(name="details", nillable=true)
    @XmlElement(name="detail")
    @JsonProperty(value="details")
    public Map<String, Object> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, Object> details) {
        this.details = details;
    }

    public void addDetail(String key, Object value) {
        if (this.details == null) {
            this.details = new HashMap<String, Object>();
        }
        this.details.put(key, value);
    }

    public void setCreated(Change created) {
        this.created = created;
    }

    @XmlElementWrapper(name="groups", nillable=true)
    @XmlElement(name="group")
    @JsonProperty(value="groups")
    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @XmlElementWrapper(name="orgIds", nillable=true)
    @XmlElement(name="orgId")
    @JsonProperty(value="orgIds")
    public List<String> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<String> orgIds) {
        this.orgIds = orgIds;
    }

    public Set<GroupContext> getGroupContexts() {
        return this.groupContexts;
    }

    public void setGroupContexts(Set<GroupContext> groupContexts) {
        this.groupContexts = groupContexts;
    }

    public String getDefaultOrgId() {
        return this.defaultOrgId;
    }

    public void setDefaultOrgId(String defaultOrgId) {
        this.defaultOrgId = defaultOrgId;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        sb.append(", username='").append(this.username).append('\'');
        if (this.getUserId() != null) {
            sb.append(", userId=").append(this.userId);
        }
        if (this.getPerson() != null) {
            sb.append(", person=").append(this.person);
        }
        if (this.getOrgIds() != null) {
            sb.append(", orgIds=").append(this.orgIds);
        }
        if (this.getAccount() != null) {
            sb.append(", account=").append(this.account);
        }
        if (this.getDetails() != null) {
            sb.append(", details=").append(this.details);
        }
        if (this.getDefaultOrgId() != null) {
            sb.append(", defaultOrgId=").append(this.defaultOrgId);
        }
        if (this.getOwner() != null) {
            sb.append(", owner=").append(this.owner);
        }
        if (this.getCreated() != null) {
            sb.append(", created=").append(this.created);
        }
        super.toStringFields(sb);
        return sb;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }
}

