/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.main.data.repo;

import inc.yukawa.chain.base.core.domain.change.ChangeFilter;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import inc.yukawa.chain.modules.main.core.domain.group.Group;
import inc.yukawa.chain.modules.main.core.domain.group.GroupFilter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.reactive.mutiny.Mutiny;

public class GroupReadDao
extends HibernateReactiveReadDao<String, Group, GroupFilter> {
    public static final String[] SEARCH_FIELDS = new String[]{"name", "info.name", "info.shortName", "info.desc"};

    public GroupReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
        this.setLoadGraphName("fullGroup");
    }

    protected void withFetch(CriteriaQuery<?> query, Root<Group> root, GroupFilter filter) {
        root.fetch("roles", JoinType.LEFT);
        query.distinct(true);
    }

    protected List<Predicate> withPredicates(GroupFilter filter, Root<Group> root, CriteriaBuilder cb) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.whereEquals(predicates, cb, (Expression)root.get("name"), () -> ((GroupFilter)filter).getGroupName());
        this.whereIn(predicates, cb, (Expression)root.get("name"), () -> ((GroupFilter)filter).getGroupNames());
        this.whereIn(predicates, cb, (Expression)root.get("type"), () -> ((GroupFilter)filter).getTypes());
        if (Boolean.TRUE.equals(filter.getShowGlobals())) {
            ArrayList<Predicate> preds = new ArrayList<Predicate>();
            Predicate noOrg = root.get("orgId").isNull();
            preds.add(noOrg);
            this.whereEquals(preds, cb, (Expression)root.get("orgId"), () -> ((GroupFilter)filter).getOrgId());
            predicates.add(cb.or(preds.toArray(new Predicate[0])));
        } else {
            this.whereEquals(predicates, cb, (Expression)root.get("orgId"), () -> ((GroupFilter)filter).getOrgId());
        }
        this.whereEquals(predicates, cb, (Expression)root.get("parentId"), () -> ((GroupFilter)filter).getParentId());
        this.whereEquals(predicates, cb, (Expression)root.get("type"), () -> ((GroupFilter)filter).getType());
        ChangeFilter changeFilter = filter.getChange();
        if (changeFilter != null) {
            Path changePath = root.get("change");
            this.whereEquals(predicates, cb, (Expression)changePath.get("user"), () -> ((ChangeFilter)changeFilter).getUser());
            this.whereBetween(predicates, cb, (Expression)changePath.get("date"), () -> ((ChangeFilter)changeFilter).getDate());
        }
        this.whereKeyword(predicates, cb, SEARCH_FIELDS, root, () -> ((GroupFilter)filter).getKeyword());
        return predicates;
    }
}

