/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.main.data.repo;

import inc.yukawa.chain.base.core.domain.change.ChangeFilter;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import inc.yukawa.chain.modules.main.core.domain.setting.Setting;
import inc.yukawa.chain.modules.main.core.domain.setting.SettingFilter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.reactive.mutiny.Mutiny;

public class SettingReadDao
extends HibernateReactiveReadDao<String, Setting, SettingFilter> {
    public static final String[] SEARCH_FIELDS = new String[]{"name", "shortName", "desc", "value"};

    public SettingReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected List<Predicate> withPredicates(SettingFilter filter, Root<Setting> root, CriteriaBuilder cb) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.whereEquals(predicates, cb, (Expression)root.get("module"), () -> ((SettingFilter)filter).getModule());
        this.whereEquals(predicates, cb, (Expression)root.get("shortName"), () -> ((SettingFilter)filter).getShortName());
        this.whereEquals(predicates, cb, (Expression)root.get("orgId"), () -> ((SettingFilter)filter).getOrgId());
        ChangeFilter changeFilter = filter.getChange();
        if (changeFilter != null) {
            Path changePath = root.get("change");
            this.whereEquals(predicates, cb, (Expression)changePath.get("user"), () -> ((ChangeFilter)changeFilter).getUser());
            this.whereBetween(predicates, cb, (Expression)changePath.get("date"), () -> ((ChangeFilter)changeFilter).getDate());
        }
        this.whereKeyword(predicates, cb, SEARCH_FIELDS, root, () -> ((SettingFilter)filter).getKeyword());
        return predicates;
    }
}

