/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.main.data.repo;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveWriteDao;
import inc.yukawa.chain.security.domain.AccountEntity;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import java.time.Instant;
import org.hibernate.reactive.mutiny.Mutiny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AccountWriteDao
extends HibernateReactiveWriteDao<String, AccountEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(AccountWriteDao.class);

    public AccountWriteDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
        this.setGraphNames("fullAccount");
    }

    protected Mono<Integer> setPass(AccountEntity entity) {
        LOG.debug("[{}] setPass for {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)entity.getUsername());
        return this.atomicMerge((Keyed)entity, this::applySetPassCriteria);
    }

    protected void applySetPassCriteria(AccountEntity entity, CriteriaUpdate<AccountEntity> update, Root<AccountEntity> root, CriteriaBuilder cb) {
        update.set(root.get("password"), (Object)entity.getPassword());
        update.set(root.get("status").get("credentialsNonExpired"), (Object)true);
        update.set(root.get("passChangeDate"), (Object)Instant.now());
        update.where((Expression)cb.equal((Expression)root.get("username"), (Object)entity.getUsername()));
    }
}

