/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.main.data.repo;

import inc.yukawa.chain.base.core.domain.change.ChangeFilter;
import inc.yukawa.chain.base.core.domain.notification.Template;
import inc.yukawa.chain.base.core.domain.notification.TemplateFilter;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.reactive.mutiny.Mutiny;

public class TemplateReadDao
extends HibernateReactiveReadDao<String, Template, TemplateFilter> {
    public static final String[] SEARCH_FIELDS = new String[]{"id", "name", "shortName", "desc", "body"};

    public TemplateReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected List<Predicate> withPredicates(TemplateFilter filter, Root<Template> root, CriteriaBuilder cb) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.whereEquals(predicates, cb, (Expression)root.get("id"), () -> ((TemplateFilter)filter).getId());
        this.whereEquals(predicates, cb, (Expression)root.get("name"), () -> ((TemplateFilter)filter).getName());
        this.whereEquals(predicates, cb, (Expression)root.get("shortName"), () -> ((TemplateFilter)filter).getShortName());
        this.whereEquals(predicates, cb, (Expression)root.get("desc"), () -> ((TemplateFilter)filter).getDescription());
        this.whereEquals(predicates, cb, (Expression)root.get("lang"), () -> ((TemplateFilter)filter).getLang());
        ChangeFilter changeFilter = filter.getChange();
        if (changeFilter != null) {
            Path changePath = root.get("change");
            this.whereEquals(predicates, cb, (Expression)changePath.get("user"), () -> ((ChangeFilter)changeFilter).getUser());
            this.whereBetween(predicates, cb, (Expression)changePath.get("date"), () -> ((ChangeFilter)changeFilter).getDate());
        }
        this.whereKeyword(predicates, cb, SEARCH_FIELDS, root, () -> ((TemplateFilter)filter).getKeyword());
        return predicates;
    }
}

