/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.main.data.repo;

import inc.yukawa.chain.base.core.domain.change.ChangeFilter;
import inc.yukawa.chain.base.core.domain.person.PersonFilter;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import inc.yukawa.chain.modules.main.core.domain.user.User;
import inc.yukawa.chain.modules.main.core.domain.user.UserFilter;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.SetJoin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.reactive.mutiny.Mutiny;

public class UserReadDao
extends HibernateReactiveReadDao<String, User, UserFilter> {
    public static final String[] SEARCH_FIELDS = new String[]{"userId", "username", "person.firstName", "person.lastName", "person.email", "person.mobile", "person.phoneNumber"};

    public UserReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
        this.setLoadGraphName("fullUser");
    }

    protected Uni<User> enrich(User entity, UserFilter filter) {
        if (entity == null) {
            return Uni.createFrom().nullItem();
        }
        UniJoin.Builder builder = Uni.join().builder();
        builder.add(Uni.createFrom().item((Object)entity));
        if (filter == null || Boolean.TRUE.equals(filter.getWithGroupContexts())) {
            Uni listUni = Mutiny.fetch((Object)entity.getGroupContexts()).flatMap(ctxs -> Multi.createFrom().iterable((Iterable)ctxs).call(gc -> Mutiny.fetch((Object)gc.getGroups())).collect().asList());
            builder.add(listUni);
        }
        return builder.joinAll().andCollectFailures().replaceWith((Object)entity);
    }

    protected void withFetch(CriteriaQuery<?> query, Root<User> root, UserFilter filter) {
        root.fetch("person", JoinType.LEFT).fetch("addresses", JoinType.LEFT);
        query.distinct(true);
    }

    protected List<Predicate> withPredicates(UserFilter filter, Root<User> root, CriteriaBuilder cb) {
        ChangeFilter changeFilter;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.whereEquals(predicates, cb, (Expression)root.get("userId"), () -> ((UserFilter)filter).getUserId());
        this.whereEquals(predicates, cb, (Expression)root.get("username"), () -> ((UserFilter)filter).getUsername());
        this.whereEquals(predicates, cb, (Expression)root.get("defaultOrgId"), () -> ((UserFilter)filter).getDefaultOrgId());
        PersonFilter personFilter = filter.getPersonFilter();
        if (personFilter != null) {
            this.whereEquals(predicates, cb, (Expression)root.get("person").get("firstName"), () -> ((PersonFilter)personFilter).getFirstName());
            this.whereEquals(predicates, cb, (Expression)root.get("person").get("lastName"), () -> ((PersonFilter)personFilter).getLastName());
            this.whereEquals(predicates, cb, (Expression)root.get("person").get("companyName"), () -> ((PersonFilter)personFilter).getCompanyName());
            this.whereEquals(predicates, cb, (Expression)root.get("person").get("email"), () -> ((PersonFilter)personFilter).getEmail());
            this.whereEquals(predicates, cb, (Expression)root.get("person").get("phoneNumber"), () -> ((PersonFilter)personFilter).getPhoneNumber());
            this.whereEquals(predicates, cb, (Expression)root.get("person").get("mobile"), () -> ((PersonFilter)personFilter).getMobile());
            String phoneOrMobile = personFilter.getPhoneOrMobile();
            if (phoneOrMobile != null) {
                ArrayList phoneOrMobilePredicates = new ArrayList();
                this.whereEquals(phoneOrMobilePredicates, cb, (Expression)root.get("person").get("phoneNumber"), () -> ((PersonFilter)personFilter).getPhoneOrMobile());
                this.whereEquals(phoneOrMobilePredicates, cb, (Expression)root.get("person").get("mobile"), () -> ((PersonFilter)personFilter).getPhoneOrMobile());
                predicates.add(cb.or(phoneOrMobilePredicates.toArray(new Predicate[0])));
            }
        }
        if (filter.getGroups() != null) {
            SetJoin groupContextJoin = root.joinSet("groupContexts", JoinType.LEFT);
            SetJoin groupsJoin = groupContextJoin.joinSet("groups", JoinType.LEFT);
            predicates.add(groupsJoin.in((Collection)filter.getGroups()));
        }
        if (filter.getOrgIds() != null) {
            ListJoin orgIdsJoin = root.joinList("orgIds", JoinType.LEFT);
            predicates.add(orgIdsJoin.in((Collection)filter.getOrgIds()));
        }
        if ((changeFilter = filter.getChange()) != null) {
            Path changePath = root.get("change");
            this.whereEquals(predicates, cb, (Expression)changePath.get("user"), () -> ((ChangeFilter)changeFilter).getUser());
            this.whereBetween(predicates, cb, (Expression)changePath.get("date"), () -> ((ChangeFilter)changeFilter).getDate());
        }
        this.whereKeyword(predicates, cb, SEARCH_FIELDS, root, () -> ((UserFilter)filter).getKeyword());
        return predicates;
    }
}

