create table main_group
(
    name            varchar(255) not null,
    parent_id       varchar(255),
    type            varchar(255),

    info_id         varchar(255),
    info_name       varchar(255),
    info_short_name varchar(255),
    info_desc       varchar,

    org_id          varchar(255),

    change_date     timestamp,
    change_user     varchar(255),
    created_date    timestamp,
    created_user    varchar(255),

    primary key (name),
    foreign key (parent_id) references main_group (name) on delete set null
);
create index main_group_parent_id_idx ON main_group using hash (parent_id);

create table main_group_role
(
    group_name varchar(255) not null,
    role_name  varchar(255) not null,
    primary key (group_name, role_name)
);
create index main_group_role_group_name_idx ON main_group_role using hash (group_name);
create index main_group_role_role_name_idx ON main_group_role using hash (role_name);

create table main_user
(
    user_id         varchar(64)  not null,
    username        varchar(255) not null,
    info_id         varchar(255),
    info_name       varchar(255),
    info_short_name varchar(255),
    info_desc       varchar,

    details         text,
    default_org_id  varchar(255),

    company_name    varchar(255),
    email           varchar(255),
    first_name      varchar(255),
    lang            varchar(255),
    last_name       varchar(255),
    mobile          varchar(255),
    phone_number    varchar(255),
    role            varchar(255),
    salutation      varchar(255),
    short_name      varchar(255),
    title           varchar(255),
    vat_number      varchar(255),

    change_date     timestamp,
    change_user     varchar(255),
    created_date    timestamp,
    created_user    varchar(255),

    primary key (user_id)
);

create unique index main_user_username_idx ON main_user (username);
create index main_user_email_idx ON main_user (email);
create index main_user_first_name_idx ON main_user (first_name);
create index main_user_last_name_idx ON main_user (last_name);
create index main_user_mobile_idx ON main_user (mobile);
create index main_user_phone_number_idx ON main_user (phone_number);
create index main_user_change_date_idx ON main_user (change_date DESC);
create index main_user_created_date_idx ON main_user (created_date DESC);


create table main_user_group_member
(
    user_id     varchar(64)  not null,
    org_id      varchar(32)  not null,
    group_name  varchar(255) not null,
    change_date timestamp,
    change_user varchar(255),
    primary key (user_id, org_id, group_name),
    foreign key (user_id) references main_user (user_id) on delete cascade,
    foreign key (group_name) references main_group (name) on delete cascade
);
create index main_user_group_member_user_id_idx ON main_user_group_member using hash (user_id);
create index main_user_group_member_org_id_idx ON main_user_group_member using hash (org_id);

create table main_user_address
(
    user_id      varchar(64) not null,
    type         varchar(255),
    address_id   varchar(255),
    city         varchar(255),
    country_code varchar(255),
    altitude     float8,
    latitude     float8,
    longitude    float8,
    house_number varchar(255),
    region       varchar(255),
    state        varchar(255),
    street       varchar(255),
    zip_code     varchar(255),
    primary key (user_id, type),
    foreign key (user_id) references main_user (user_id) on delete cascade
);
create index main_user_address_user_id_idx ON main_user_address using hash (user_id);
create index main_user_address_city_idx ON main_user_address (city);
create index main_user_address_country_code_idx ON main_user_address (country_code);
create index main_user_address_street_idx ON main_user_address (street);
create index main_user_address_zip_code_idx ON main_user_address (zip_code);

create table main_account
(
    user_id                 varchar(64) not null,
    password                varchar,

    enabled                 boolean     not null default true,
    account_non_expired     boolean     not null default true,
    account_non_locked      boolean     not null default true,
    credentials_non_expired boolean     not null default true,

    primary key (user_id),
    foreign key (user_id) references main_user (user_id) on delete cascade
);

create view main_user_orgs as
select distinct user_id, org_id
from main_user_group_member;

create view main_account_roles as
select gm.user_id, gm.org_id, gr.role_name
from main_user_group_member gm
         left join main_group_role gr
                   on gm.group_name = gr.group_name;

create table main_notification_template
(
    template_id  varchar(255),

    name         varchar(255),
    short_name   varchar(255),
    "desc"       varchar,

    body         varchar,

    change_date  timestamp,
    change_user  varchar(255),
    created_date timestamp,
    created_user varchar(255),

    primary key (template_id)
);

create table main_setting
(
    setting_id   varchar(255),

    name         varchar(255),
    short_name   varchar(255) not null,
    "desc"       varchar,

    module       varchar(64)  not null,
    value        varchar,
    org_id       varchar(64)  not null,

    change_date  timestamp,
    change_user  varchar(255),

    primary key (setting_id),
    unique (org_id, module, short_name)
);

create index main_setting_pk_idx ON main_setting (org_id, module, short_name);
create index main_setting_short_name_idx ON main_setting (short_name);
create index main_setting_org_id_idx ON main_setting (org_id);
create index main_setting_module_idx ON main_setting (module);
create index main_setting_name_idx ON main_setting (name);
create index main_setting_value_idx ON main_setting (value);
