-- drop foreign keys
alter table main_push_token
    drop constraint main_push_token_username_fkey;
alter table main_push_topic_subscription
    drop constraint main_push_topic_subscription_username_fkey;

-- main_push_token
update main_push_token t
set username = u.user_id
from main_user u
where t.username = u.username;

alter table main_push_token
    rename column username to user_id;
alter index main_push_token_username_idx rename to main_push_token_user_id_idx;

-- main_push_topic_subscription
update main_push_topic_subscription t
set username = u.user_id
from main_user u
where t.username = u.username;

alter table main_push_topic_subscription
    rename column username to user_id;
alter index main_push_topic_subscription_username_idx rename to main_push_topic_subscription_user_id_idx;

-- main_group
update main_group t
set change_user = u.user_id
from main_user u
where t.change_user = u.username;

update main_group t
set created_user = u.user_id
from main_user u
where t.created_user = u.username;

-- main_notification_template
update main_notification_template t
set change_user = u.user_id
from main_user u
where t.change_user = u.username;

update main_notification_template t
set created_user = u.user_id
from main_user u
where t.created_user = u.username;

-- main_setting
update main_setting t
set change_user = u.user_id
from main_user u
where t.change_user = u.username;

--  recreate foreign keys
alter table main_push_token
    add foreign key (user_id) references main_user (user_id) on delete cascade;
alter table main_push_topic_subscription
    add foreign key (user_id) references main_user (user_id) on delete cascade;
