-- notification templates

delete
from main_notification_template
where template_id in ('sendWhatsappTextRequestBodyTemplate', 'sendWhatsappTemplatedRequestBodyTemplate');

insert into main_notification_template (template_id, name, short_name, lang, "desc", body, change_date, change_user,
                                        created_date, created_user)
values ('sendWhatsappTextRequestBodyTemplate', 'Whatsapp text message request template',
        'sendWhatsappTextRequestBodyTemplate', 'en', 'Request body to send free text Whatsapp message',
        '{
            "messaging_product" : "whatsapp",
            "recipient_type" : "individual",
            "to": "[(${to})]",
            "type": "text",
            "text" : {
                "preview_url": "true",
                "body": "[(${text})]"
            }
        }'
           , current_timestamp, 'admin', current_timestamp, 'admin');

insert into main_notification_template (template_id, name, short_name, lang, "desc", body, change_date, change_user,
                                        created_date, created_user)
values ('sendWhatsappTemplatedRequestBodyTemplate', 'Whatsapp templated message request template',
        'sendWhatsappTemplatedRequestBodyTemplate', 'en', 'Request body to send templated Whatsapp message',
        '{
            "messaging_product" : "whatsapp",
            "recipient_type" : "individual",
            "to": "[(${to})]",
            "type": "template",
            "template" : {
                "name": "[(${templateName})]",
                "language": {
                    "code": "[(${languageCode})]"
                },
                "components" : [
                    {
                      "type": "body",
                      "parameters": [
                        [# th:each="n, iterStat : ${positionalParams}"]
                          {
                            "type": "text",
                            "text": "[(${n})]"
                          }[(${iterStat.last} ? '''' : '','')]
                        [/]
                      ]
                    }
                ]
            }
        }'
           , current_timestamp, 'admin', current_timestamp, 'admin');
