/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.kafka.config;

import inc.yukawa.chain.base.core.anno.ChainRequest;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.module.AspectInfo;
import inc.yukawa.chain.base.core.domain.module.ModuleInfo;
import inc.yukawa.chain.base.core.service.ModuleAspect;
import inc.yukawa.chain.base.service.ModuleService;
import inc.yukawa.chain.base.service.util.ExtHostUtil;
import inc.yukawa.chain.base.service.util.ModUtil;
import inc.yukawa.chain.modules.main.core.aspect.MainModule;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"mod-aspect", "all-aspects", "default"})
public class ModAspectConfig {
    @Value(value="${external.host:${server.host:auto}}")
    protected String extHost;
    @Value(value="${external.port:${server.port}}")
    protected int extPort;
    @Value(value="${external.path:${server.servlet.context-path}}")
    protected String extPath;
    @Value(value="${external.schemes:http,https}")
    protected String extSchemes;

    @Bean
    public ModuleAspect modAspect(ModuleInfo info) {
        return new ModuleService(info);
    }

    @Bean
    public Set<AspectInfo> aspectInfos() {
        return Arrays.stream(this.aspects()).map(cls -> {
            String apiUrl = this.apiUrl("main");
            String reg = cls.getSimpleName().toLowerCase().replace("aspect", "");
            Set requests = ModUtil.scanRequestNames((Class)cls, ChainRequest.class).toStream().collect(Collectors.toSet());
            return new AspectInfo(reg, apiUrl + "/" + reg, new Info(cls.getSimpleName(), reg, cls.getName()), requests);
        }).collect(Collectors.toSet());
    }

    private Class[] aspects() {
        return MainModule.ASPECTS;
    }

    @Bean
    public ModuleInfo moduleInfo(Set<AspectInfo> aspects) {
        String apiUrl = this.apiUrl("main");
        ModuleInfo modInfo = new ModuleInfo("Main Module", "main", null, apiUrl, "2.0.0");
        modInfo.setAspects(aspects);
        return modInfo;
    }

    protected String apiUrl(String reg) {
        return ExtHostUtil.getExtServiceUrl((String)this.extSchemes, (String)this.extHost, (int)this.extPort, (String)("chain/" + reg));
    }
}

