/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.kafka.config;

import inc.yukawa.chain.base.rest.config.SwaggerConfigBase;
import inc.yukawa.chain.base.service.util.ExtHostUtil;
import inc.yukawa.chain.modules.main.kafka.rest.ModuleRestCtrl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spi.service.contexts.SecurityContextBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebFlux;

@Configuration
@EnableSwagger2WebFlux
public class SwaggerConfig
extends SwaggerConfigBase {
    @Autowired(required=false)
    @Qualifier(value="main.PermitEndpoints")
    private List<String> permitAllEndpoints;
    @Value(value="${chain.security.login.form:http://security-service:3081/auth/login}")
    protected String loginUrl;

    protected Docket apiBase() {
        return new Docket(DocumentationType.SWAGGER_2).host(this.swaggerHost()).protocols(new HashSet<String>(Arrays.asList(this.swaggerSchemes()))).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)ModuleRestCtrl.class.getPackage().getName())).paths(PathSelectors.any()).build().ignoredParameterTypes(new Class[]{ServerWebExchange.class}).genericModelSubstitutes(new Class[]{Mono.class}).genericModelSubstitutes(new Class[]{ResponseEntity.class}).genericModelSubstitutes(new Class[]{Flux.class});
    }

    @Bean
    @Profile(value={"open"})
    public Docket apiOpen() {
        return this.apiBase();
    }

    @Bean
    @Profile(value={"!open"})
    public Docket apiJwt() {
        return this.apiBase().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().contact(this.contract()).title("CHAIN Main").description(String.format("%s (%s)", ExtHostUtil.getExtHost((String)this.extHost, (int)this.extPort), new Date())).version("2.0.0").build();
    }

    private Contact contract() {
        return new Contact("Yukawa Systems", "http://www.yukawa.de/chain", "info@chain.yukawa.de");
    }

    private List<SecurityScheme> securitySchemes() {
        return Arrays.asList(this.oauth());
    }

    private List<SecurityContext> securityContexts() {
        Predicate any = PathSelectors.any();
        if (this.permitAllEndpoints != null) {
            for (String endpoint : this.permitAllEndpoints) {
                any = any.and(PathSelectors.ant((String)endpoint).negate());
            }
        }
        SecurityContextBuilder scb = SecurityContext.builder().securityReferences(this.tokenAuthRefs()).forPaths(any);
        return Collections.singletonList(scb.build());
    }

    SecurityScheme oauth() {
        return new OAuthBuilder().name("OAuthLogin").scopes(Arrays.asList(this.scopes())).grantTypes(this.grantTypes()).build();
    }

    List<GrantType> grantTypes() {
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        grantTypes.add((GrantType)new ResourceOwnerPasswordCredentialsGrant(this.loginUrl));
        return grantTypes;
    }

    private AuthorizationScope[] scopes() {
        return new AuthorizationScope[0];
    }

    @Bean
    @Profile(value={"!open"})
    SecurityConfiguration securityConfiguration() {
        return SecurityConfigurationBuilder.builder().clientId(this.appPrefix + "main").realm("ChainRealm").appName(this.appPrefix + "main").scopeSeparator(",").build();
    }

    protected List<SecurityReference> tokenAuthRefs() {
        return Collections.singletonList(new SecurityReference("OAuthLogin", this.scopes()));
    }
}

