/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.kafka.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import inc.yukawa.chain.base.webflux.config.WebFluxConfigBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@Configuration
@EnableWebFlux
public class WebFluxConfig
extends WebFluxConfigBase
implements WebFluxConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebFluxConfig.class);

    public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        configurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(this.objectMapper, new MimeType[0]));
        configurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(this.objectMapper, new MimeType[0]));
    }
}

