/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.kafka.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import inc.yukawa.chain.kafka.config.KafkaStreamsConfigBase;
import inc.yukawa.chain.modules.main.core.domain.setting.Setting;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
public class KafkaConfig
extends KafkaStreamsConfigBase {
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = super.objectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    protected ProducerFactory<String, ?> producerFactory() {
        return new DefaultKafkaProducerFactory(this.producerConfig(), Serdes.String().serializer(), (Serializer)new JsonSerializer(this.objectMapper()));
    }

    @Bean(value={"main.SettingProducerTemplate"})
    @Profile(value={"settings-aspect", "all-aspects", "default"})
    public KafkaTemplate<String, Setting> settingDataProducer(@Value(value="${chain.main.settings.topic}") String topicName) {
        KafkaTemplate template = new KafkaTemplate(this.producerFactory(), true);
        template.setDefaultTopic(topicName);
        return template;
    }
}

