/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.kafka.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.kafka.dao.mono.KafkaStoreReadDao;
import inc.yukawa.chain.kafka.util.KafkaUtil;
import inc.yukawa.chain.modules.main.core.domain.group.Group;
import inc.yukawa.chain.modules.main.core.domain.group.GroupFilter;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class GroupStore
extends KafkaStoreReadDao<String, Group, GroupFilter> {
    private static final String GROUPS_STORE = "groups";
    @Value(value="${chain.main.group.topic}")
    private String topic;
    private final Serde<Group> groupSerDes;

    public GroupStore(ObjectMapper mapper, @Qualifier(value="main.GroupStreamsProps") Properties streamProps) {
        super(GROUPS_STORE, streamProps);
        this.groupSerDes = KafkaUtil.getSerDes(Group.class, (boolean)false, (ObjectMapper)mapper);
    }

    protected StreamsBuilder buildStreams() {
        StreamsBuilder builder = new StreamsBuilder();
        Materialized m = Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)this.storeName)).withKeySerde(Serdes.String()).withValueSerde(this.groupSerDes);
        builder.globalTable(this.topic, Consumed.with((Serde)Serdes.String(), this.groupSerDes), m);
        return builder;
    }

    public boolean matches(Group value, GroupFilter filter) {
        return filter == null || value != null && this.matches(value.getName(), filter.getGroupName()) && this.contains(value.getName(), filter.getKeyword());
    }
}

