/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.modules.main.kafka.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.kafka.dao.mono.KafkaStoreReadDao;
import inc.yukawa.chain.kafka.util.KafkaUtil;
import inc.yukawa.chain.security.domain.RoleInfo;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class RoleStore
extends KafkaStoreReadDao<String, RoleInfo, RoleInfo> {
    private static final String ROLES_STORE = "roles";
    private final String topic;
    private final Serde<RoleInfo> infoSerDes;

    @Autowired
    public RoleStore(ObjectMapper mapper, @Qualifier(value="main.RoleStreamsProps") Properties streamProps, @Qualifier(value="main.RoleInfoTopic") NewTopic topic) {
        super(ROLES_STORE, streamProps);
        this.infoSerDes = KafkaUtil.getSerDes(RoleInfo.class, (boolean)false, (ObjectMapper)mapper);
        this.topic = topic.name();
    }

    protected StreamsBuilder buildStreams() {
        StreamsBuilder builder = new StreamsBuilder();
        Materialized m = Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)this.storeName)).withKeySerde(Serdes.String()).withValueSerde(this.infoSerDes);
        builder.globalTable(this.topic, Consumed.with((Serde)Serdes.String(), this.infoSerDes), m);
        builder.stream("chain-dummy", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        return builder;
    }

    public boolean matches(RoleInfo value, RoleInfo filter) {
        return filter == null || value != null && this.matches(value.getId(), filter.getId()) && this.contains(value.getScope(), filter.getScope()) && this.contains(value.getName(), filter.getName()) && this.contains(value.getShortName(), filter.getShortName()) && this.matches(value.getDesc(), filter.getDesc());
    }
}

