/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security;

import inc.yukawa.chain.base.core.error.AuthorizationError;
import inc.yukawa.chain.security.atomic.AtomicSecurity;
import inc.yukawa.chain.security.error.AtomicError;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import inc.yukawa.chain.security.principal.ChainSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

public abstract class ChainSecurityAtomic
implements ChainSecurity {
    protected static Logger log = LoggerFactory.getLogger(ChainSecurityAtomic.class);
    private String myModuleReg;
    private String myModuleAdmin;
    private String mySuperUser;
    private boolean myTrace;

    protected abstract AtomicSecurity getAtomic(String var1);

    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) throws AuthorizationError {
        if (principal != null) {
            if (this.getSuperUser() != null && principal.inRole(this.getSuperUser())) {
                if (this.isTrace()) {
                    log.debug("checkCall: {}:{} skipped in role {}", new Object[]{this.getModuleReg(), callName, this.getSuperUser()});
                }
                return paras;
            }
            if (this.getModuleAdmin() != null && principal.inRole(this.getModuleAdmin())) {
                if (this.isTrace()) {
                    log.debug("checkCall: {}:{} skipped in role {}", new Object[]{this.getModuleReg(), callName, this.getModuleAdmin()});
                }
                return paras;
            }
        }
        AtomicSecurity atomic = this.getAtomic(callName);
        if (this.isTrace()) {
            log.debug("checkCall: " + this.getModuleReg() + ":" + callName + "\n\t usr: " + principal + "\n\t atr: " + atomic);
        }
        try {
            return atomic.checkCall(callName, paras, principal);
        }
        catch (AtomicError error) {
            error.setRequestName(callName);
            error.setModuleName(this.getModuleReg());
            if (this.isTrace()) {
                log.warn("checkCall: {}:{} failed - msg: {}", new Object[]{this.getModuleReg(), callName, error.getMessage()});
            }
            throw new AccessDeniedException(error.getMessage(), (Throwable)error);
        }
    }

    public String getModuleReg() {
        return this.myModuleReg;
    }

    public void setModuleReg(String value) {
        this.myModuleReg = value;
    }

    public String getModuleAdmin() {
        return this.myModuleAdmin;
    }

    public void setModuleAdmin(String value) {
        this.myModuleAdmin = value;
    }

    public String getSuperUser() {
        return this.mySuperUser;
    }

    public void setSuperUser(String value) {
        this.mySuperUser = value;
    }

    public boolean isTrace() {
        return this.myTrace;
    }

    public void setTrace(boolean value) {
        this.myTrace = value;
    }
}

