/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security;

import inc.yukawa.chain.security.ChainSecurityAtomic;
import inc.yukawa.chain.security.atomic.AtomicSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ChainSecurityAtomicIoc
extends ChainSecurityAtomic {
    private final ApplicationContext context;
    protected static Logger log = LoggerFactory.getLogger(ChainSecurityAtomicIoc.class);
    private String myDefaultAtomicName;

    public ChainSecurityAtomicIoc(ApplicationContext context) {
        this.context = context;
        this.setDefaultAtomicName("defaultAtomic");
    }

    @Override
    protected AtomicSecurity getAtomic(String callName) {
        try {
            return (AtomicSecurity)this.context.getBean(callName, AtomicSecurity.class);
        }
        catch (Exception error) {
            if (this.isTrace()) {
                log.debug("No atomic found for " + callName + " using " + this.getDefaultAtomicName());
            }
            return (AtomicSecurity)this.context.getBean(this.getDefaultAtomicName(), AtomicSecurity.class);
        }
    }

    public String toString() {
        return "ChainSecurityAtomicIoc{mod=" + this.getModuleReg() + ", super=" + this.getSuperUser() + ", admin=" + this.getModuleAdmin() + ", trace=" + this.isTrace() + "}";
    }

    public String getDefaultAtomicName() {
        return this.myDefaultAtomicName;
    }

    public void setDefaultAtomicName(String value) {
        this.myDefaultAtomicName = value;
    }
}

