/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.base.core.error.AuthorizationError;
import inc.yukawa.chain.security.atomic.PrincipalAtomic;
import inc.yukawa.chain.security.principal.ChainPrincipal;

public class RoleListAtomic
extends PrincipalAtomic {
    private Iterable<String> roles;
    private boolean checkAnd;

    public RoleListAtomic() {
    }

    public RoleListAtomic(Iterable<String> roles) {
        this.roles = roles;
    }

    @Override
    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) throws AuthorizationError {
        Object[] result = super.checkCall(callName, paras, principal);
        if (this.isCheckAnd()) {
            this.checkAnd(paras, principal);
        } else {
            this.checkOr(paras, principal);
        }
        return result;
    }

    private void checkAnd(Object[] paras, ChainPrincipal principal) throws AuthorizationError {
        for (String role : this.getRoles()) {
            if (principal.inRole(role)) continue;
            this.raiseError(principal);
        }
    }

    private void checkOr(Object[] paras, ChainPrincipal principal) throws AuthorizationError {
        for (String role : this.getRoles()) {
            if (!principal.inRole(role)) continue;
            return;
        }
        this.raiseError(principal);
    }

    @Override
    public String toString() {
        return "RoleListAtomic{" + this.roles + "}";
    }

    public Iterable<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Iterable<String> roles) {
        this.roles = roles;
    }

    public boolean isCheckAnd() {
        return this.checkAnd;
    }

    public void setCheckAnd(boolean checkAnd) {
        this.checkAnd = checkAnd;
    }
}

