/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.base.core.domain.access.Owned;
import inc.yukawa.chain.base.core.domain.access.Owner;
import inc.yukawa.chain.base.core.error.AuthorizationError;
import inc.yukawa.chain.security.atomic.PrincipalAtomic;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainOwnerLimit
extends PrincipalAtomic {
    private static final Logger log = LoggerFactory.getLogger(ChainOwnerLimit.class);
    private Set<String> groups;

    @Override
    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) throws AuthorizationError {
        Object[] result = super.checkCall(callName, paras, principal);
        Owner owned = this.getOwned(principal, paras);
        if (owned == null) {
            log.warn("checkCall: {} is not owned {}", (Object)callName, (Object)paras);
            throw this.createError(principal, callName + " - is not owned " + Arrays.asList(paras));
        }
        this.limitOwner(principal, owned, this.groups);
        return result;
    }

    protected Owner getOwned(ChainPrincipal principal, Object[] paras) throws AuthorizationError {
        Object para = paras[0];
        if (para instanceof Owned) {
            Owned owned = (Owned)para;
            if (owned.getOwner() == null) {
                owned.setOwner(new Owner());
            }
            return owned.getOwner();
        }
        return null;
    }

    protected void limitOwner(ChainPrincipal principal, Owner owned, Set<String> groups) {
        owned.setUser(principal.getUserId());
        owned.setGroups(groups);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }
}

