/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.security.atomic.PropertyLimit;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForbiddenPropertyLimit
extends PropertyLimit {
    private static final Logger log = LoggerFactory.getLogger(ForbiddenPropertyLimit.class);
    private String forbiddenProperty;

    @Override
    public String toString() {
        return "ForbiddenPropertyLimit{" + this.forbiddenProperty + "}";
    }

    @Override
    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) {
        Object para = paras[this.getParaIndex()];
        try {
            String forbiddenPropertyValue = BeanUtils.getProperty((Object)para, (String)this.forbiddenProperty);
            if (forbiddenPropertyValue != null) {
                log.warn("{} trying to set forbidden property {}", (Object)principal.getUserId(), (Object)this.forbiddenProperty);
                this.raiseError(principal);
            }
        }
        catch (Exception beanEx) {
            log.warn(beanEx.getClass().getSimpleName() + " : " + beanEx, (Throwable)beanEx);
            throw this.createError(principal, beanEx.getMessage());
        }
        return super.checkCall(callName, paras, principal);
    }

    public String getForbiddenProperty() {
        return this.forbiddenProperty;
    }

    public void setForbiddenProperty(String forbiddenProperty) {
        this.forbiddenProperty = forbiddenProperty;
    }
}

